/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.io.java;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.Comment;
import org.eclipse.gmt.modisco.java.CompilationUnit;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.io.java.JDTVisitor;
import org.eclipse.gmt.modisco.java.io.java.binding.PendingElement;

public final class CommentsManager {
    private CommentsManager() {
    }

    public static void resolveCommentPositions(JDTVisitor visitor) {
        int index;
        org.eclipse.jdt.core.dom.CompilationUnit cuNode = visitor.getCuNode();
        CompilationUnit moDiscoCuNode = (CompilationUnit)visitor.getBijectiveMap().getValue((org.eclipse.jdt.core.dom.ASTNode)cuNode);
        ArrayList<Comment> commentsList = new ArrayList<Comment>(visitor.getCommentsBinding().getValues());
        TreeMap<Integer, org.eclipse.jdt.core.dom.ASTNode> nodesMap = new TreeMap<Integer, org.eclipse.jdt.core.dom.ASTNode>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return -o1.compareTo(o2);
            }
        });
        for (org.eclipse.jdt.core.dom.ASTNode node : visitor.getBijectiveMap().getKeys()) {
            index = cuNode.firstLeadingCommentIndex(node);
            if (index == -1) continue;
            nodesMap.put(index, node);
        }
        for (Integer indexMap : nodesMap.keySet()) {
            ASTNode element;
            index = indexMap;
            org.eclipse.jdt.core.dom.ASTNode node = (org.eclipse.jdt.core.dom.ASTNode)nodesMap.get(indexMap);
            int lastIndex = cuNode.lastTrailingCommentIndex(node);
            if (lastIndex == -1) {
                lastIndex = indexMap + 1;
            }
            if ((element = visitor.getBijectiveMap().getValue(node)) instanceof PendingElement) {
                element = ((PendingElement)element).getClientNode() != null ? ((PendingElement)element).getClientNode() : visitor.getBijectiveMap().getValue(node.getParent());
            }
            while (index != -1 && index < cuNode.getCommentList().size()) {
                org.eclipse.jdt.core.dom.ASTNode commentNode = (org.eclipse.jdt.core.dom.ASTNode)cuNode.getCommentList().get(index);
                Comment comment = visitor.getCommentsBinding().get(commentNode);
                if (comment != null && commentsList.contains(comment)) {
                    if (index < lastIndex) {
                        ++index;
                        if (!(element instanceof Package)) {
                            element.getComments().add((Object)comment);
                        } else {
                            moDiscoCuNode.getComments().add((Object)comment);
                        }
                        commentsList.remove(comment);
                        continue;
                    }
                    index = -1;
                    continue;
                }
                index = -1;
            }
        }
        for (Comment comment : commentsList) {
            if (visitor.getRootTypeOrEnum() != null) {
                visitor.getRootTypeOrEnum().getComments().add((Object)comment);
                continue;
            }
            EcoreUtil.delete((EObject)comment);
        }
    }

    public static String extractCommentContent(org.eclipse.jdt.core.dom.Comment comment, String originalFileContent) {
        String result = originalFileContent.substring(comment.getStartPosition(), comment.getStartPosition() + comment.getLength());
        return result;
    }
}

