/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.io.java.binding;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.io.java.binding.Binding;
import org.eclipse.gmt.modisco.java.io.java.binding.ClassBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.FieldBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.IBindingFactory;
import org.eclipse.gmt.modisco.java.io.java.binding.Messages;
import org.eclipse.gmt.modisco.java.io.java.binding.MethodBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.PackageBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.ParameterBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.UnresolvedBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.VariableBinding;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.WildcardType;

public final class JDTDelegateBindingFactory
implements IBindingFactory {
    private static IBindingFactory instance = new JDTDelegateBindingFactory();

    private JDTDelegateBindingFactory() {
    }

    public static IBindingFactory getInstance() {
        return instance;
    }

    public Binding getBindingForName(Name name) {
        Binding result = this.getBinding(name.resolveBinding());
        if (result == null) {
            result = new UnresolvedBinding(name.getFullyQualifiedName());
        }
        return result;
    }

    public Binding getBindingForPrimitiveType(PrimitiveType type) {
        Binding result = new Binding(type.getPrimitiveTypeCode().toString());
        return result;
    }

    public Binding getBindingForParameterizedType(ParameterizedType type) {
        Binding result = null;
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            Status status = new Status(2, "org.eclipse.gmt.modisco.java.discoverer", "*** WARNING : binding '" + type.toString() + "' unresolved.", (Throwable)new Exception());
            JavaActivator.getDefault().getLog().log((IStatus)status);
            result = new UnresolvedBinding(type.toString());
        } else {
            result = new Binding(binding.getQualifiedName());
        }
        return result;
    }

    public Binding getBindingForWildCardType(WildcardType type) {
        Binding result = null;
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            Status status = new Status(2, "org.eclipse.gmt.modisco.java.discoverer", "Unresolved binding", (Throwable)new Exception("*** WARNING : binding '" + type.toString() + "' unresolved."));
            JavaActivator.getDefault().getLog().log((IStatus)status);
            result = new UnresolvedBinding(type.toString());
        } else {
            result = new Binding(binding.getQualifiedName());
        }
        return result;
    }

    public Binding getBindingForArrayType(ArrayType type) {
        Binding result = null;
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            Status status = new Status(2, "org.eclipse.gmt.modisco.java.discoverer", "Unresolved binding", (Throwable)new Exception("*** WARNING : binding '" + type.toString() + "' unresolved."));
            JavaActivator.getDefault().getLog().log((IStatus)status);
            result = new UnresolvedBinding(type.toString());
        } else {
            result = new ClassBinding();
            result.setName(binding.getQualifiedName());
        }
        return result;
    }

    public Binding getBindingForClassInstanceCreation(ClassInstanceCreation constructorCall) {
        Binding result = null;
        IMethodBinding binding = constructorCall.resolveConstructorBinding();
        if (binding == null || binding.getDeclaringClass() == null) {
            Status status = new Status(2, "org.eclipse.gmt.modisco.java.discoverer", "Unresolved binding", (Throwable)new Exception("*** WARNING : binding '" + constructorCall.toString() + Messages.JDTDelegateBindingFactory_10));
            JavaActivator.getDefault().getLog().log((IStatus)status);
            result = new UnresolvedBinding(constructorCall.toString());
        } else {
            result = this.getMethodBinding(binding);
        }
        return result;
    }

    public Binding getBindingForConstructorInvocation(ConstructorInvocation constructorCall) {
        Binding result = null;
        IMethodBinding binding = constructorCall.resolveConstructorBinding();
        if (binding == null || binding.getDeclaringClass() == null) {
            Status status = new Status(2, "org.eclipse.gmt.modisco.java.discoverer", "Unresolved binding", (Throwable)new Exception("*** WARNING : binding '" + constructorCall.toString() + "' unresolved."));
            JavaActivator.getDefault().getLog().log((IStatus)status);
            result = new UnresolvedBinding(constructorCall.toString());
        } else {
            result = this.getMethodBinding(binding);
        }
        return result;
    }

    public Binding getBindingForSuperConstructorInvocation(SuperConstructorInvocation constructorCall) {
        Binding result = null;
        IMethodBinding binding = constructorCall.resolveConstructorBinding();
        if (binding == null || binding.getDeclaringClass() == null) {
            Status status = new Status(2, "org.eclipse.gmt.modisco.java.discoverer", "Unresolved binding", (Throwable)new Exception("*** WARNING : binding '" + constructorCall.toString() + "' unresolved."));
            JavaActivator.getDefault().getLog().log((IStatus)status);
            result = new UnresolvedBinding(constructorCall.toString());
        } else {
            result = this.getMethodBinding(binding);
        }
        return result;
    }

    private Binding getBinding(IBinding binding) {
        Binding result = null;
        if (binding instanceof IMethodBinding) {
            result = this.getMethodBinding((IMethodBinding)binding);
        } else if (binding instanceof ITypeBinding) {
            result = this.getClassBinding((ITypeBinding)binding, false);
        } else if (binding instanceof IPackageBinding) {
            result = this.getPackageBinding((IPackageBinding)binding);
        } else if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
            result = this.getFieldBinding((IVariableBinding)binding);
        } else if (binding instanceof IVariableBinding && !((IVariableBinding)binding).isField()) {
            result = this.getVariableBinding((IVariableBinding)binding);
        }
        return result;
    }

    private MethodBinding getMethodBinding(IMethodBinding methodBinding) {
        IMethodBinding binding = methodBinding.getMethodDeclaration();
        MethodBinding result = new MethodBinding();
        result.setName(binding.getName());
        result.setDeclaringClass(this.getClassBinding(binding.getDeclaringClass(), false));
        result.setConstructor(binding.isConstructor());
        result.setAnnotationMember(binding.isAnnotationMember());
        int i = 0;
        while (i < binding.getParameterTypes().length) {
            result.getParameters().add(this.getParameterBinding(binding.getParameterTypes()[i]));
            ++i;
        }
        return result;
    }

    private ParameterBinding getParameterBinding(ITypeBinding binding) {
        ParameterBinding result = new ParameterBinding();
        result.setDimensions(binding.getDimensions());
        if (binding.isArray()) {
            result.setElementType(this.getClassBinding(binding.getElementType(), true));
        } else {
            result.setElementType(this.getClassBinding(binding, true));
        }
        return result;
    }

    private PackageBinding getPackageBinding(IPackageBinding binding) {
        PackageBinding result = new PackageBinding();
        result.setName(binding.getName());
        return result;
    }

    private ClassBinding getClassBinding(ITypeBinding bindingParameter, boolean isParameterBinding) {
        ITypeBinding binding = bindingParameter.getTypeDeclaration();
        ClassBinding result = new ClassBinding();
        if (binding.isTypeVariable() && isParameterBinding) {
            return this.getClassBinding(binding.getErasure(), isParameterBinding);
        }
        if (binding.isAnonymous()) {
            result.setName(binding.getKey());
        } else {
            int n;
            int n2;
            ITypeBinding[] iTypeBindingArray;
            result.setName(binding.getName());
            result.setTypeVariable(binding.isTypeVariable());
            result.setInterface(binding.isInterface());
            result.setEnum(binding.isEnum());
            result.setAnnotation(binding.isAnnotation());
            if (binding.getPackage() != null) {
                result.setOwnerPackage(this.getPackageBinding(binding.getPackage()));
            }
            if (binding.getDeclaringClass() != null) {
                result.setDeclaringClass(this.getClassBinding(binding.getDeclaringClass(), false));
            }
            ITypeBinding superClass = binding.getSuperclass();
            if (binding.isClass() && superClass != null && !superClass.getQualifiedName().equals("java.lang.Object")) {
                result.setSuperClass(this.getClassBinding(superClass, false));
            }
            if (!binding.isAnnotation() && binding.getInterfaces() != null) {
                iTypeBindingArray = binding.getInterfaces();
                n2 = iTypeBindingArray.length;
                n = 0;
                while (n < n2) {
                    ITypeBinding anInterface = iTypeBindingArray[n];
                    if (!anInterface.getQualifiedName().equals("java.lang.Object")) {
                        result.getSuperInterfaces().add(this.getClassBinding(anInterface, false));
                    }
                    ++n;
                }
            }
            if (binding.getTypeParameters() != null) {
                iTypeBindingArray = binding.getTypeParameters();
                n2 = iTypeBindingArray.length;
                n = 0;
                while (n < n2) {
                    ITypeBinding typeParameter = iTypeBindingArray[n];
                    result.addTypeParameters(typeParameter.getName());
                    ++n;
                }
            }
        }
        return result;
    }

    private FieldBinding getFieldBinding(IVariableBinding binding) {
        FieldBinding result = new FieldBinding();
        result.setName(binding.getName());
        result.setEnumConstant(binding.isEnumConstant());
        if (binding.getDeclaringClass() != null) {
            result.setDeclaringClass(this.getClassBinding(binding.getDeclaringClass(), false));
        }
        return result;
    }

    private VariableBinding getVariableBinding(IVariableBinding binding) {
        VariableBinding result = new VariableBinding();
        result.setName(String.valueOf(binding.getVariableId()));
        return result;
    }

    public boolean isLocal(Name name) {
        return this.isLocalVariable(name) || this.isLocalMethod(name);
    }

    private boolean isLocalVariable(Name name) {
        IBinding binding = name.resolveBinding();
        return binding instanceof IVariableBinding && !((IVariableBinding)binding).isField();
    }

    private boolean isLocalMethod(Name name) {
        IBinding binding = name.resolveBinding();
        return binding instanceof IMethodBinding && ((IMethodBinding)binding).getDeclaringClass().isAnonymous();
    }
}

