/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.gmt.modisco.workflow.ui.Messages;
import org.eclipse.gmt.modisco.workflow.ui.WorkflowTransformationTab;
import org.eclipse.gmt.modisco.workflow.ui.common.Common;
import org.eclipse.gmt.modisco.workflow.ui.common.ExportDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class MoDiscoExportTab
extends AbstractLaunchConfigurationTab {
    private ScrolledComposite scrollContainer;
    private Composite rootContainer;
    private String idWorkflow;
    private Combo comboEngine;
    private List<String> idEngineList = new ArrayList<String>();
    private Button buttonExportDiscoverer;
    private Button buttonExportWorkflow;
    private Button buttonExportModelInternal;
    private ILaunchConfiguration currentConfiguration;

    public void createControl(Composite parent) {
        this.scrollContainer = new ScrolledComposite(parent, 768);
        this.scrollContainer.setExpandHorizontal(true);
        this.scrollContainer.setExpandVertical(true);
        this.rootContainer = new Composite((Composite)this.scrollContainer, 0);
        GridLayout layoutRoot = new GridLayout();
        this.rootContainer.setLayout((Layout)layoutRoot);
        layoutRoot.numColumns = 1;
        layoutRoot.verticalSpacing = 9;
        this.scrollContainer.setContent((Control)this.rootContainer);
        this.createGroupWorkflowType();
        this.createGroupExport();
        this.initializeCombo();
        this.setControl((Control)this.rootContainer);
        this.setControl((Control)this.scrollContainer);
    }

    private void createGroupWorkflowType() {
        Group groupWorkflow = new Group(this.rootContainer, 0);
        groupWorkflow.setText(Messages.MoDiscoExportTab_0);
        GridLayout layoutGroup = new GridLayout();
        groupWorkflow.setLayout((Layout)layoutGroup);
        layoutGroup.numColumns = 3;
        layoutGroup.verticalSpacing = 9;
        GridData gdHoriz = new GridData(768);
        groupWorkflow.setLayoutData((Object)gdHoriz);
        Label labelWorkflow = new Label((Composite)groupWorkflow, 0);
        labelWorkflow.setText(Messages.MoDiscoExportTab_1);
        labelWorkflow.pack();
        this.comboEngine = new Combo((Composite)groupWorkflow, 8);
        this.comboEngine.setLayoutData((Object)gdHoriz);
        this.comboEngine.pack();
        this.comboEngine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MoDiscoExportTab.this.idWorkflow = (String)MoDiscoExportTab.this.idEngineList.get(MoDiscoExportTab.this.comboEngine.getSelectionIndex());
                MoDiscoExportTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createGroupExport() {
        GridData gdText = new GridData();
        gdText.horizontalAlignment = 0x1000008;
        GridData gdLabel = new GridData();
        gdLabel.horizontalSpan = 2;
        gdLabel.grabExcessHorizontalSpace = true;
        Group groupExport = SWTFactory.createGroup((Composite)this.rootContainer, (String)Messages.MoDiscoExportTab_2, (int)3, (int)2, (int)768);
        Label nameDiscoverer = new Label((Composite)groupExport, 0);
        nameDiscoverer.setText(Messages.MoDiscoExportTab_3);
        this.buttonExportDiscoverer = SWTFactory.createPushButton((Composite)groupExport, (String)Messages.MoDiscoExportTab_4, (Image)Activator.getImageDescriptor("icon/buttonExport.png").createImage());
        this.buttonExportDiscoverer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MoDiscoExportTab.this.exportDiscoverer();
            }
        });
        nameDiscoverer.setLayoutData((Object)gdLabel);
        this.buttonExportDiscoverer.setLayoutData((Object)gdText);
        Label outputPath = new Label((Composite)groupExport, 0);
        outputPath.setText(Messages.MoDiscoExportTab_6);
        outputPath.setLayoutData((Object)gdLabel);
        this.buttonExportWorkflow = SWTFactory.createPushButton((Composite)groupExport, (String)Messages.MoDiscoExportTab_7, (Image)Activator.getImageDescriptor("icon/buttonExport.png").createImage());
        this.buttonExportWorkflow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MoDiscoExportTab.this.handleExportLocationButtonSelected(false);
                Common.getInstance().refreshPackageExplorer();
            }
        });
        this.buttonExportWorkflow.setLayoutData((Object)gdText);
        GridData gdLabel2 = new GridData();
        gdLabel2.horizontalSpan = 2;
        Label modelInternalLabel = new Label((Composite)groupExport, 0);
        modelInternalLabel.setText(Messages.MoDiscoExportTab_9);
        modelInternalLabel.setLayoutData((Object)gdLabel2);
        this.buttonExportModelInternal = SWTFactory.createPushButton((Composite)groupExport, (String)Messages.MoDiscoExportTab_10, (Image)Activator.getImageDescriptor("icon/buttonExport.png").createImage());
        this.buttonExportModelInternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MoDiscoExportTab.this.handleExportLocationButtonSelected(true);
                Common.getInstance().refreshPackageExplorer();
            }
        });
        this.buttonExportModelInternal.setLayoutData((Object)gdText);
    }

    private void exportDiscoverer() {
        IStatus status = this.getController().verifyNameToExportDiscoverer();
        if (status.isOK()) {
            ExportDialog dialog = new ExportDialog(this.currentConfiguration.getName(), this.getShell());
            dialog.open();
            if (dialog.isExport()) {
                this.getController().exportMoDiscoWorkflowToDiscovererProject(dialog.getProjectName(), dialog.getSymbolicName(), dialog.getBaseName());
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MoDiscoExportTab_12, (String)(String.valueOf(status.getMessage()) + Messages.MoDiscoExportTab_13));
        }
    }

    public String getName() {
        return Messages.MoDiscoExportTab_14;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.currentConfiguration = configuration;
        try {
            this.comboEngine.select(this.idEngineList.indexOf(configuration.getAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, MoDiscoWorkflowLaunchConstants.idMinimaliste)));
            this.idWorkflow = configuration.getAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, MoDiscoWorkflowLaunchConstants.idMinimaliste);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, this.idWorkflow);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public Image getImage() {
        return Activator.getImageDescriptor("icon/exportIcon.png").createImage();
    }

    private void initializeCombo() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gmt.modisco.workflowtype");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("workflowCore")) {
                    this.comboEngine.add(element.getAttribute("name"));
                    this.idEngineList.add(extension.getUniqueIdentifier());
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void handleExportLocationButtonSelected(boolean exportModelinternal) {
        IWorkspaceRoot currentContainer = ResourcesPlugin.getWorkspace().getRoot();
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)currentContainer, false, Messages.MoDiscoExportTab_16);
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String fullPath = ResourcesPlugin.getWorkspace().getRoot().findMember(path).getLocation().makeAbsolute().toString();
            if (exportModelinternal) {
                this.getController().exportInternalModel(fullPath);
            } else {
                this.getController().exportWorkflow(this.currentConfiguration, fullPath);
            }
        }
    }

    private ControllerWorkflowTransformation getController() {
        ControllerWorkflowTransformation controller = null;
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.getLaunchConfigurationDialog().getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab instanceof WorkflowTransformationTab) {
                controller = ((WorkflowTransformationTab)tab).getController();
                break;
            }
            ++n2;
        }
        return controller;
    }
}

