/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs;

import java.util.List;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.Messages;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.controls.MetamodelSelectionControl;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.controls.QuerySetsSelectionControl;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationPropertiesDialog
extends Dialog {
    private static final int METAMODEL_GROUP_WIDTH = 400;
    private static final int METAMODEL_GROUP_HEIGHT = 400;
    private static final int IMPORTS_GROUP_WIDTH = 400;
    private static final int IMPORTS_GROUP_HEIGHT = 500;
    private String initialMetamodel;
    private boolean initialAllQuerySetsAvailable = true;
    private List<String> initialQuerySets;
    private MetamodelSelectionControl metamodelSelectionControl;
    private String fMetamodel;
    private boolean allQuerySetsAvailable;
    private String[] selectedQuerySets;
    private QuerySetsSelectionControl querySetsSelectionControl;
    private final boolean readOnly;

    public CustomizationPropertiesDialog(Shell parentShell, boolean readOnly) {
        super(parentShell);
        this.readOnly = readOnly;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        contents.setLayout((Layout)new GridLayout(2, true));
        Composite leftPane = new Composite(contents, 0);
        leftPane.setLayoutData((Object)new GridData(4, 4, true, true));
        leftPane.setLayout((Layout)new GridLayout());
        this.createMetamodelPane(leftPane);
        Composite rightPane = new Composite(contents, 0);
        rightPane.setLayoutData((Object)new GridData(4, 4, true, true));
        rightPane.setLayout((Layout)new GridLayout());
        this.createImportedQuerySetsPane(rightPane);
        return contents;
    }

    private void createMetamodelPane(Composite contents) {
        Group metamodelGroup = new Group(contents, 0);
        metamodelGroup.setLayout((Layout)new GridLayout());
        metamodelGroup.setText(Messages.CustomizationPropertiesDialog_metamodel);
        GridData metamodelGroupData = new GridData(4, 4, true, true);
        metamodelGroupData.widthHint = 400;
        metamodelGroupData.heightHint = 400;
        metamodelGroup.setLayoutData((Object)metamodelGroupData);
        this.metamodelSelectionControl = new MetamodelSelectionControl((Composite)metamodelGroup);
        this.metamodelSelectionControl.setEnabled(!this.readOnly);
        this.metamodelSelectionControl.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.initialMetamodel != null) {
            this.metamodelSelectionControl.getFilteredList().setSelection((Object[])new String[]{this.initialMetamodel});
        }
    }

    private void createImportedQuerySetsPane(Composite contents) {
        Group importsGroup = new Group(contents, 0);
        importsGroup.setLayout((Layout)new GridLayout());
        importsGroup.setText(Messages.CustomizationPropertiesDialog_querySets);
        GridData importsGroupData = new GridData(4, 4, true, true);
        importsGroupData.widthHint = 400;
        importsGroupData.heightHint = 500;
        importsGroup.setLayoutData((Object)importsGroupData);
        this.querySetsSelectionControl = new QuerySetsSelectionControl((Composite)importsGroup);
        this.querySetsSelectionControl.setEnabled(!this.readOnly);
        this.querySetsSelectionControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.querySetsSelectionControl.setAllQuerySetsAvailable(this.initialAllQuerySetsAvailable);
        if (this.initialQuerySets != null) {
            this.querySetsSelectionControl.setSelectedQuerySets(this.initialQuerySets);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CustomizationPropertiesDialog_customizationProperties);
        newShell.setImage(ImageProvider.getInstance().getMoDiscoIcon());
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        if (!this.readOnly) {
            if (this.metamodelSelectionControl.getSelectedMetamodel() == null) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.CustomizationPropertiesDialog_noMetamodelSelected, (String)Messages.CustomizationPropertiesDialog_metamodelMustBeSelected);
                return;
            }
            this.fMetamodel = this.metamodelSelectionControl.getSelectedMetamodel();
            this.allQuerySetsAvailable = this.querySetsSelectionControl.getAllQuerySetsAvailable();
            this.selectedQuerySets = this.querySetsSelectionControl.getSelectedQuerySets();
        }
        super.okPressed();
    }

    public void setInitialMetamodel(String metamodel) {
        this.initialMetamodel = metamodel;
    }

    public void setInitialQuerySets(List<String> querySets) {
        this.initialQuerySets = querySets;
    }

    public String getMetamodel() {
        return this.fMetamodel;
    }

    public String[] getSelectedQuerySets() {
        return this.selectedQuerySets;
    }

    public boolean isAllQuerySetsAvailable() {
        return this.allQuerySetsAvailable;
    }

    public void setInitialImportAllQuerySets(boolean importAllQuerySets) {
        this.initialAllQuerySetsAvailable = importAllQuerySets;
    }
}

