/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.Messages;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.ui.dialogs.QuerySelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditFeatureValueDialog
extends Dialog {
    private static final int QUERIES_TREE_WIDTH = 250;
    private static final int QUERIES_TREE_HEIGHT = 300;
    private final boolean withCondition;
    private final boolean withDefault;
    private Button rbStatic;
    private Button rbQuery;
    private Button rbDefault;
    private TreeViewer conditionQueryViewer;
    private TreeViewer fQueryViewer;
    private ValueType selectedValueType;
    private String staticValue;
    private String initialStaticValue;
    private String fInitialQuerySetName;
    private String fInitialQueryName;
    private String initialConditionQuerySetName;
    private String initialConditionQueryName;
    private String selectedQuerySetName;
    private String selectedQueryName;
    private String selectedConditionQuerySetName;
    private String selectedConditionQueryName;
    private final List<String> availableQuerySets;
    private final String fExpectedReturnType;
    private final EClass fExpectedScope;
    private final ViewerFilter conditionQueriesFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ModelQuery) {
                ModelQuery modelQuery = (ModelQuery)element;
                EClassifier returnType = modelQuery.getReturnType();
                if (!"EBoolean".equals(returnType.getName())) {
                    return false;
                }
                return EditFeatureValueDialog.this.hasExpectedScope(modelQuery);
            }
            return true;
        }
    };

    protected EditFeatureValueDialog(Shell parentShell, boolean withCondition, boolean withDefault, List<String> availableQuerySets, String expectedReturnType, EClass customizedMetaclass) {
        super(parentShell);
        this.withCondition = withCondition;
        this.withDefault = withDefault;
        this.availableQuerySets = availableQuerySets;
        this.fExpectedReturnType = expectedReturnType;
        this.fExpectedScope = customizedMetaclass;
    }

    protected Control createDialogArea(Composite parent) {
        Collection<ModelQuerySet> querySets = this.loadQuerySets();
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        int numColumns = this.withCondition ? 2 : 1;
        contents.setLayout((Layout)new GridLayout(numColumns, true));
        if (this.withCondition) {
            this.createConditionPane(querySets, contents);
        }
        Composite rightPane = new Composite(contents, 0);
        rightPane.setLayoutData((Object)new GridData(4, 4, true, true));
        rightPane.setLayout((Layout)new GridLayout());
        Group featureValueGroup = new Group(rightPane, 0);
        featureValueGroup.setLayout((Layout)new GridLayout());
        featureValueGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        featureValueGroup.setText(Messages.EditFeatureValueDialog_featureValue);
        Group typeGroup = new Group((Composite)featureValueGroup, 0);
        typeGroup.setLayout((Layout)new GridLayout());
        typeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        typeGroup.setText(Messages.EditFeatureValueDialog_type);
        if (this.withDefault) {
            this.rbDefault = new Button((Composite)typeGroup, 16);
            this.rbDefault.setText(Messages.EditFeatureValueDialog_defaultValue);
        }
        this.rbStatic = new Button((Composite)typeGroup, 16);
        this.rbStatic.setText(Messages.EditFeatureValueDialog_staticValue);
        this.rbQuery = new Button((Composite)typeGroup, 16);
        this.rbQuery.setText(Messages.EditFeatureValueDialog_queryValue);
        final Composite dynamicZone = new Composite((Composite)featureValueGroup, 0);
        dynamicZone.setLayoutData((Object)new GridData(4, 4, true, true));
        final StackLayout stackLayout = new StackLayout();
        dynamicZone.setLayout((Layout)stackLayout);
        final Composite staticValueComposite = new Composite(dynamicZone, 0);
        staticValueComposite.setLayout((Layout)new GridLayout());
        this.createValueEditor(staticValueComposite);
        final Composite dynamicValueComposite = new Composite(dynamicZone, 0);
        dynamicValueComposite.setLayout((Layout)new GridLayout());
        ViewerFilter queryFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ModelQuery) {
                    ModelQuery modelQuery = (ModelQuery)element;
                    EClassifier returnType = modelQuery.getReturnType();
                    if (!EditFeatureValueDialog.this.fExpectedReturnType.equals(returnType.getName())) {
                        return false;
                    }
                    return EditFeatureValueDialog.this.hasExpectedScope(modelQuery);
                }
                return true;
            }
        };
        FilteredTree filteredTree = QuerySelectionDialog.createFilteredTree((Composite)dynamicValueComposite, querySets, (ViewerFilter)queryFilter, (boolean)false);
        GridData queryGridData = new GridData(4, 4, true, true);
        queryGridData.widthHint = 250;
        queryGridData.heightHint = 300;
        filteredTree.setLayoutData((Object)queryGridData);
        this.fQueryViewer = filteredTree.getViewer();
        this.selectQueryInViewer(this.fInitialQuerySetName, this.fInitialQueryName, this.fQueryViewer, querySets);
        final Composite defaultValueComposite = new Composite(dynamicZone, 0);
        this.rbStatic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                stackLayout.topControl = staticValueComposite;
                dynamicZone.layout();
            }
        });
        this.rbQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                stackLayout.topControl = dynamicValueComposite;
                dynamicZone.layout();
            }
        });
        if (this.withDefault) {
            this.rbDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    stackLayout.topControl = defaultValueComposite;
                    dynamicZone.layout();
                }
            });
        }
        if (this.selectedValueType == null) {
            this.selectedValueType = ValueType.STATIC;
        }
        switch (this.selectedValueType) {
            case DERIVED: {
                this.rbQuery.setSelection(true);
                stackLayout.topControl = dynamicValueComposite;
                break;
            }
            case DEFAULT: {
                this.rbDefault.setSelection(true);
                stackLayout.topControl = defaultValueComposite;
                break;
            }
            default: {
                this.rbStatic.setSelection(true);
                stackLayout.topControl = staticValueComposite;
            }
        }
        dynamicZone.layout();
        return contents;
    }

    private void createConditionPane(Collection<ModelQuerySet> querySets, Composite contents) {
        Composite leftPane = new Composite(contents, 0);
        leftPane.setLayoutData((Object)new GridData(4, 4, true, true));
        leftPane.setLayout((Layout)new GridLayout());
        Group conditionGroup = new Group(leftPane, 0);
        conditionGroup.setLayout((Layout)new GridLayout());
        conditionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        conditionGroup.setText(Messages.EditFeatureValueDialog_queryForCondition);
        FilteredTree filteredTree = QuerySelectionDialog.createFilteredTree((Composite)conditionGroup, querySets, (ViewerFilter)this.conditionQueriesFilter, (boolean)false);
        GridData queryGridData = new GridData(4, 4, true, true);
        queryGridData.widthHint = 250;
        queryGridData.heightHint = 300;
        filteredTree.setLayoutData((Object)queryGridData);
        this.conditionQueryViewer = filteredTree.getViewer();
        this.selectQueryInViewer(this.initialConditionQuerySetName, this.initialConditionQueryName, this.conditionQueryViewer, querySets);
    }

    private void selectQueryInViewer(String initialQuerySetName, String initialQueryName, TreeViewer queryViewer, Collection<ModelQuerySet> querySets) {
        if (initialQuerySetName == null || initialQueryName == null) {
            return;
        }
        block0: for (ModelQuerySet querySet : querySets) {
            if (!initialQuerySetName.equals(querySet.getName())) continue;
            for (ModelQuery query : querySet.getQueries()) {
                if (!initialQueryName.equals(query.getName())) continue;
                queryViewer.setSelection((ISelection)new StructuredSelection((Object)query));
                continue block0;
            }
        }
    }

    protected abstract void createValueEditor(Composite var1);

    public String getStaticValue() {
        return this.staticValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void okPressed() {
        ModelQuery query;
        Object firstElement;
        IStructuredSelection selection;
        if (this.rbStatic.getSelection()) {
            this.selectedValueType = ValueType.STATIC;
        } else if (this.rbQuery.getSelection()) {
            this.selectedValueType = ValueType.DERIVED;
            selection = (IStructuredSelection)this.fQueryViewer.getSelection();
            firstElement = selection.getFirstElement();
            if (!(firstElement instanceof ModelQuery)) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.EditFeatureValueDialog_noQuerySelected, (String)Messages.EditFeatureValueDialog_queryMustBeSelected);
                return;
            }
            query = (ModelQuery)firstElement;
            this.selectedQueryName = query.getName();
            this.selectedQuerySetName = query.getModelQuerySet().getName();
        } else if (this.withDefault && this.rbDefault.getSelection()) {
            this.selectedValueType = ValueType.DEFAULT;
        }
        if (this.withCondition) {
            selection = (IStructuredSelection)this.conditionQueryViewer.getSelection();
            firstElement = selection.getFirstElement();
            if (!(firstElement instanceof ModelQuery)) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.EditFeatureValueDialog_noConditionQuerySelected, (String)Messages.EditFeatureValueDialog_conditionQueryMustBeSelected);
                return;
            }
            query = (ModelQuery)firstElement;
            this.selectedConditionQueryName = query.getName();
            this.selectedConditionQuerySetName = query.getModelQuerySet().getName();
        }
        super.okPressed();
    }

    public ValueType getSelectedValueType() {
        return this.selectedValueType;
    }

    public void setSelectedValueType(ValueType selectedValueType) {
        this.selectedValueType = selectedValueType;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.EditFeatureValueDialog_editFeatureValue);
        newShell.setImage(ImageProvider.getInstance().getMoDiscoIcon());
    }

    protected boolean isResizable() {
        return true;
    }

    public void setInitialStaticValue(String value) {
        this.initialStaticValue = value;
    }

    public void setSelectedQuery(String querySetName, String queryName) {
        this.fInitialQuerySetName = querySetName;
        this.fInitialQueryName = queryName;
    }

    public void setSelectedConditionQuery(String querySetName, String queryName) {
        this.initialConditionQuerySetName = querySetName;
        this.initialConditionQueryName = queryName;
    }

    public String getSelectedQueryName() {
        return this.selectedQueryName;
    }

    public String getSelectedQuerySetName() {
        return this.selectedQuerySetName;
    }

    public String getSelectedConditionQueryName() {
        return this.selectedConditionQueryName;
    }

    public String getSelectedConditionQuerySetName() {
        return this.selectedConditionQuerySetName;
    }

    private Collection<ModelQuerySet> loadQuerySets() {
        Collection allModelQuerySets = ModelQuerySetCatalog.getSingleton().getAllModelQuerySets();
        ArrayList<ModelQuerySet> querySets = new ArrayList<ModelQuerySet>();
        for (ModelQuerySet modelQuerySet : allModelQuerySets) {
            if (modelQuerySet == null || this.availableQuerySets != null && !this.availableQuerySets.contains(modelQuerySet.getName())) continue;
            querySets.add(modelQuerySet);
        }
        return querySets;
    }

    protected void setStaticValue(String staticValue) {
        this.staticValue = staticValue;
    }

    protected String getInitialStaticValue() {
        return this.initialStaticValue;
    }

    private boolean hasExpectedScope(ModelQuery modelQuery) {
        EList scope = modelQuery.getScope();
        if (scope.isEmpty()) {
            return true;
        }
        for (EClass aScope : scope) {
            if (!aScope.isSuperTypeOf(this.fExpectedScope)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueType {
        STATIC,
        DERIVED,
        DEFAULT;

    }
}

