/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.core.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.common.core.CommonModiscoActivator;
import org.eclipse.gmt.modisco.common.core.resource.IMoDiscoResourceListener;
import org.eclipse.gmt.modisco.common.core.resource.MoDiscoResourceSet;

public class MoDiscoResourceListenerGroup {
    private final Map<IMoDiscoResourceListener, URI> listeners = new HashMap<IMoDiscoResourceListener, URI>();
    private final URI watchedResourceUri;

    public MoDiscoResourceListenerGroup(URI watchedResourceUri) {
        this.watchedResourceUri = watchedResourceUri;
        if (MoDiscoResourceSet.DEBUG) {
            Status status = new Status(1, "org.eclipse.gmt.modisco.common", "[" + this.getClass().getSimpleName() + ".MoDiscoResourceListnerGroup()] " + this.watchedResourceUri);
            CommonModiscoActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    public void notifyChange() {
        if (MoDiscoResourceSet.DEBUG) {
            Status status = new Status(1, "org.eclipse.gmt.modisco.common", "[" + this.getClass().getSimpleName() + ".notifyChange()] " + this.watchedResourceUri + " nbListners=" + this.listeners.size());
            CommonModiscoActivator.getDefault().getLog().log((IStatus)status);
        }
        for (IMoDiscoResourceListener listener : this.listeners.keySet()) {
            try {
                listener.aListenedResourceHasChanged(this.watchedResourceUri, this.listeners.get(listener));
            }
            catch (Exception e) {
                Status status2 = new Status(4, "org.eclipse.gmt.modisco.common", "An exception happened while notifying change of: " + this.watchedResourceUri + " to: " + listener, (Throwable)e);
                CommonModiscoActivator.getDefault().getLog().log((IStatus)status2);
            }
        }
    }

    public void addListener(IMoDiscoResourceListener listener, URI resourceUri) {
        this.listeners.put(listener, resourceUri);
    }
}

