/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.xml.internal.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.xml.Attribute;
import org.eclipse.gmt.modisco.xml.Comment;
import org.eclipse.gmt.modisco.xml.DocumentTypeDeclaration;
import org.eclipse.gmt.modisco.xml.Element;
import org.eclipse.gmt.modisco.xml.Namespace;
import org.eclipse.gmt.modisco.xml.ProcessingInstruction;
import org.eclipse.gmt.modisco.xml.Root;
import org.eclipse.gmt.modisco.xml.Text;
import org.eclipse.gmt.modisco.xml.emf.moDiscoXMLFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericXMLHandler
extends DefaultHandler
implements LexicalHandler {
    public static final String XMLNS = "xmlns";
    public static final String OPTION_IGNORE_WHITESPACES = "OPTION_IGNORE_WHITESPACES";
    public static final String OPTION_LIGHTWEIGHT_MODEL = "OPTION_IGNORE_WHITESPACES";
    private Map<String, Object> parameters;
    private Resource container;
    private Root root;
    private Element current;
    private DocumentTypeDeclaration dtd;
    private boolean nextIsCDATA = false;
    private List<ProcessingInstruction> leadingPIs = null;
    private Boolean ignoreWhiteSpaces = null;
    private Boolean lightWeightModel = null;

    public GenericXMLHandler(Resource resource, Map<String, Object> options) {
        this.container = resource;
        this.parameters = options;
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (this.root == null) {
            this.root = moDiscoXMLFactory.eINSTANCE.createRoot();
            this.root.setName(qName);
            this.container.getContents().add((Object)this.root);
            this.current = this.root;
            if (this.dtd != null) {
                this.root.setDtd(this.dtd);
            }
            if (this.leadingPIs != null) {
                this.root.getLeadingPIs().addAll(this.leadingPIs);
            }
        } else {
            Element newElement = moDiscoXMLFactory.eINSTANCE.createElement();
            newElement.setName(qName);
            this.current.getChildren().add((Object)newElement);
            this.current = newElement;
        }
        int i = 0;
        while (i < attrs.getLength()) {
            String name = attrs.getQName(i);
            if (this.current == this.root && name.startsWith(XMLNS)) {
                Namespace newNamespace = moDiscoXMLFactory.eINSTANCE.createNamespace();
                if (name.length() == XMLNS.length()) {
                    newNamespace.setName("");
                } else {
                    newNamespace.setName(name.substring(XMLNS.length() + 1));
                }
                newNamespace.setValue(attrs.getValue(i));
                this.root.getNamespaces().add((Object)newNamespace);
            } else {
                Attribute newAttribute = moDiscoXMLFactory.eINSTANCE.createAttribute();
                newAttribute.setName(name);
                newAttribute.setValue(attrs.getValue(i));
                this.current.getChildren().add((Object)newAttribute);
            }
            ++i;
        }
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        this.current = this.current.getParent();
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.current != null) {
            boolean hasContent = true;
            if (this.minimizeInformations()) {
                hasContent = false;
                int index = start;
                while (!hasContent && index < start + length) {
                    hasContent = !this.isIndentOrLineDelimiterChar(ch[index]);
                    ++index;
                }
            }
            if (hasContent) {
                String text = new String(ch, start, length);
                if (this.ignoreWhiteSpaces()) {
                    text = text.trim();
                }
                if (text.length() > 0) {
                    Text newElement = this.nextIsCDATA ? moDiscoXMLFactory.eINSTANCE.createCDATA() : moDiscoXMLFactory.eINSTANCE.createText();
                    newElement.setName(text);
                    this.current.getChildren().add((Object)newElement);
                }
            }
        }
    }

    @Override
    public final void comment(char[] ch, int start, int length) throws SAXException {
        String text;
        if (this.current != null && !this.minimizeInformations() && (text = new String(ch, start, length)).length() > 0) {
            Comment newElement = moDiscoXMLFactory.eINSTANCE.createComment();
            newElement.setName(text);
            this.current.getChildren().add((Object)newElement);
        }
    }

    @Override
    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
        DocumentTypeDeclaration newDtd = moDiscoXMLFactory.eINSTANCE.createDocumentTypeDeclaration();
        newDtd.setName(name);
        newDtd.setPublicID(publicId);
        newDtd.setSystemID(systemId);
        this.dtd = newDtd;
        if (this.root != null) {
            this.root.setDtd(this.dtd);
        }
    }

    private boolean ignoreWhiteSpaces() {
        if (this.ignoreWhiteSpaces == null) {
            this.ignoreWhiteSpaces = this.parameters != null && this.parameters.get("OPTION_IGNORE_WHITESPACES") != null ? (Boolean)this.parameters.get("OPTION_IGNORE_WHITESPACES") : Boolean.valueOf(false);
        }
        return this.ignoreWhiteSpaces;
    }

    private boolean minimizeInformations() {
        if (this.lightWeightModel == null) {
            this.lightWeightModel = this.parameters != null && this.parameters.get("OPTION_IGNORE_WHITESPACES") != null ? (Boolean)this.parameters.get("OPTION_IGNORE_WHITESPACES") : Boolean.valueOf(false);
        }
        return this.lightWeightModel;
    }

    private boolean isIndentOrLineDelimiterChar(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    @Override
    public final void endCDATA() throws SAXException {
        this.nextIsCDATA = false;
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
        ProcessingInstruction newElement = moDiscoXMLFactory.eINSTANCE.createProcessingInstruction();
        newElement.setName(target);
        newElement.setData(data);
        if (this.current != null) {
            this.current.getChildren().add((Object)newElement);
        } else {
            if (this.leadingPIs == null) {
                this.leadingPIs = new ArrayList<ProcessingInstruction>();
            }
            this.leadingPIs.add(newElement);
        }
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public final void startCDATA() throws SAXException {
        this.nextIsCDATA = true;
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }
}

