/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.ui.views;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.common.core.builder.AbstractMoDiscoCatalog;
import org.eclipse.gmt.modisco.common.core.builder.EcoreCatalog;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.common.core.utils.ImageUtils;
import org.eclipse.gmt.modisco.common.ui.Messages;
import org.eclipse.gmt.modisco.common.ui.MoDiscoCommonUIPlugin;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class PackageRegistryView
extends ViewPart
implements AbstractMoDiscoCatalog.ModiscoCatalogChangeListener {
    private static final int JOB_SCHEDULE_DELAY = 500;
    private static final int COLUMN_WIDTH = 200;
    private TreeViewer ecoreViewer;
    private TreeViewerColumn nameColumn;
    private TreeViewerColumn locationColumn;
    private Job refreshJob = null;
    private TreeViewerColumn nsURIColumn;

    public TreeViewer getModelQuerySetViewer() {
        return this.ecoreViewer;
    }

    public TreeViewerColumn getNameColumn() {
        return this.nameColumn;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.ecoreViewer = new TreeViewer(parent, 66308);
        this.ecoreViewer.getTree().setLinesVisible(true);
        this.ecoreViewer.getTree().setHeaderVisible(true);
        this.createNameColumn();
        this.createLocationColumn();
        this.createNsUriColumn();
        this.ecoreViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof EPackage.Registry) {
                    EPackage.Registry registry = (EPackage.Registry)inputElement;
                    ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
                    ArrayList keys = new ArrayList();
                    keys.addAll(registry.keySet());
                    for (String nsURI : keys) {
                        try {
                            EPackage ePackage = registry.getEPackage(nsURI);
                            if (ePackage == null) {
                                throw new Exception("ePackage is null for : " + nsURI);
                            }
                            ePackages.add(ePackage);
                        }
                        catch (Exception e) {
                            MoDiscoLogger.logWarning((Throwable)e, (String)("An error happened while loading an EPackage from Package.Registry.INSTANCE: " + nsURI), (Plugin)MoDiscoCommonUIPlugin.getDefault());
                        }
                    }
                    return ePackages.toArray();
                }
                if (inputElement == null) {
                    return new Object[0];
                }
                if (inputElement instanceof String) {
                    String message = (String)inputElement;
                    return new Object[]{message};
                }
                throw new RuntimeException("Unexpected element type: " + inputElement.getClass().getName());
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof EPackage.Registry) {
                    EPackage.Registry registry = (EPackage.Registry)parentElement;
                    return registry.values().toArray();
                }
                if (parentElement == null || parentElement instanceof String) {
                    return new Object[0];
                }
                throw new RuntimeException("Unexpected element type: " + parentElement.getClass().getName());
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof EPackage.Registry;
            }

            public void dispose() {
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.ecoreViewer);
        this.refresh();
        EcoreCatalog.getSingleton().addChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    private void createNsUriColumn() {
        this.nsURIColumn = new TreeViewerColumn(this.ecoreViewer, 0);
        this.nsURIColumn.getColumn().setText(Messages.PackageRegistryView_nsURI);
        this.nsURIColumn.getColumn().setWidth(400);
        this.nsURIColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof EPackage)) {
                    return "";
                }
                EPackage ePackage = (EPackage)element;
                return ePackage.getNsURI();
            }
        });
        this.addSorter(this.nsURIColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                EPackage ePackage1 = (EPackage)e1;
                EPackage ePackage2 = (EPackage)e2;
                String uri1 = ePackage1.getNsURI();
                String uri2 = ePackage2.getNsURI();
                int compare = uri1.compareTo(uri2);
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void createLocationColumn() {
        this.locationColumn = new TreeViewerColumn(this.ecoreViewer, 0);
        this.locationColumn.getColumn().setText(Messages.PackageRegistryView_Location);
        this.locationColumn.getColumn().setWidth(400);
        this.locationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof EPackage)) {
                    return "";
                }
                EPackage ePackage = (EPackage)element;
                return EcoreCatalog.getSingleton().getOriginalLocation(ePackage);
            }
        });
        this.addSorter(this.locationColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                EPackage ePackage1 = (EPackage)e1;
                EPackage ePackage2 = (EPackage)e2;
                String uri1 = EcoreCatalog.getSingleton().getOriginalLocation(ePackage1);
                String uri2 = EcoreCatalog.getSingleton().getOriginalLocation(ePackage2);
                int compare = uri1.compareTo(uri2);
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void createNameColumn() {
        this.nameColumn = new TreeViewerColumn(this.ecoreViewer, 0);
        this.nameColumn.getColumn().setText(Messages.PackageRegistryView_Name);
        this.nameColumn.getColumn().setWidth(200);
        this.nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EPackage) {
                    EPackage ePackage = (EPackage)element;
                    return ePackage.getName();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                return "";
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        });
        this.addSorter(this.nameColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                EPackage ePackage1 = (EPackage)e1;
                EPackage ePackage2 = (EPackage)e2;
                int compare = ePackage1.getName().compareTo(ePackage2.getName());
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void addSorter(final TreeViewerColumn column, final ViewerSorter viewerSorter) {
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeViewer treeView = PackageRegistryView.this.getModelQuerySetViewer();
                treeView.setSorter(viewerSorter);
                treeView.getTree().setSortColumn(column.getColumn());
                if (treeView.getTree().getSortDirection() == 128) {
                    treeView.getTree().setSortDirection(1024);
                } else if (treeView.getTree().getSortDirection() == 1024) {
                    treeView.getTree().setSortDirection(128);
                } else {
                    treeView.getTree().setSortDirection(128);
                }
                treeView.refresh();
            }
        });
    }

    public void setFocus() {
        this.ecoreViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        EcoreCatalog.getSingleton().removeChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    private void refresh() {
        if (this.refreshJob == null) {
            this.refreshJob = new Job(Messages.PackageRegistryView_RefreshingPackageRegistryView){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            PackageRegistryView.this.getModelQuerySetViewer().setInput((Object)Messages.PackageRegistryView_0);
                        }
                    });
                    final EPackage.Registry registry = EPackage.Registry.INSTANCE;
                    PackageRegistryView.this.preloadRegistry(registry);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            if (!PackageRegistryView.this.getModelQuerySetViewer().getControl().isDisposed()) {
                                PackageRegistryView.this.getModelQuerySetViewer().setInput((Object)registry);
                                PackageRegistryView.this.getNameColumn().getColumn().pack();
                                PackageRegistryView.this.getModelQuerySetViewer().refresh();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        }
        this.refreshJob.cancel();
        this.refreshJob.setPriority(50);
        this.refreshJob.schedule(500L);
    }

    void preloadRegistry(EPackage.Registry registry) {
        ArrayList keys = new ArrayList();
        keys.addAll(registry.keySet());
        for (String nsURI : keys) {
            try {
                registry.getEPackage(nsURI);
            }
            catch (Exception e) {
                MoDiscoLogger.logWarning((Throwable)e, (String)("An error happened while loading an EPackage from Package.Registry.INSTANCE: " + nsURI), (Plugin)MoDiscoCommonUIPlugin.getDefault());
            }
        }
    }

    public void added(EObject eObject, IFile file) {
        this.refresh();
    }

    public void changed(EObject eObject, IFile file) {
        this.refresh();
    }

    public void removed(IFile file) {
        this.refresh();
    }
}

