/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.facet.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetAttribute;
import org.eclipse.gmt.modisco.infra.facet.FacetReference;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.gmt.modisco.infra.facet.FacetStructuralFeature;
import org.eclipse.gmt.modisco.infra.facet.Shortcut;
import org.eclipse.gmt.modisco.infra.facet.core.exception.ModiscoFacetException;
import org.eclipse.gmt.modisco.infra.facet.core.exception.StructuralConstraintViolationException;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.AbstractModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.Activator;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetContext {
    private final HashSet<Facet> appliedFacets = new HashSet();
    private final List<EStructuralFeature> appliedFeatures = new ArrayList<EStructuralFeature>();
    private final HashSet<Resource> resources = new HashSet();

    public void addComposedResource(Resource resource) {
        this.resources.add(resource);
        TreeIterator allContents = EcoreUtil.getAllContents((Resource)resource, (boolean)false);
        while (allContents.hasNext()) {
            EObject element = (EObject)allContents.next();
            if (element.eResource() == resource) continue;
            this.resources.add(element.eResource());
        }
    }

    public void addFacetSet(FacetSet facetSet) {
        for (Facet facet : facetSet.getFacets()) {
            this.addFacet(facet);
        }
    }

    public void addFacet(Facet facet) {
        if (!this.appliedFacets.contains(facet)) {
            this.appliedFacets.add(facet);
            for (EStructuralFeature feature : facet.getEStructuralFeatures()) {
                if (!(feature instanceof FacetStructuralFeature) && !(feature instanceof Shortcut)) continue;
                this.appliedFeatures.add(feature);
            }
        }
    }

    public boolean isInstance(EObject eObject, Facet facet) throws ModelQueryException {
        ModelQuery modelQuery = facet.getConditionQuery();
        boolean result = false;
        boolean isSuperType = false;
        for (EClass superType : facet.getESuperTypes()) {
            if (!superType.isSuperTypeOf(eObject.eClass())) continue;
            isSuperType = true;
            break;
        }
        if (isSuperType) {
            if (modelQuery == null) {
                result = true;
            } else {
                AbstractModelQuery abstractModelQuery = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(modelQuery);
                result = (Boolean)abstractModelQuery.basicEvaluate(eObject);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(EObject eObject, EStructuralFeature structuralFeature) throws ModelQueryException, ModiscoFacetException {
        if (structuralFeature == null) {
            throw new ModiscoFacetException("The parameter named structuralFeature is null");
        }
        Object result = null;
        if (!this.appliedFeatures.contains(structuralFeature)) throw new ModiscoFacetException("The structuralFeature must be registered into the context, please use the " + FacetContext.class.getSimpleName() + ".add(FacetSet) method.");
        Facet facet = (Facet)structuralFeature.eContainer();
        if (!this.isInstance(eObject, facet)) throw new ModiscoFacetException("The eObject parameter must be an instance of : " + facet.getName());
        if (structuralFeature instanceof FacetStructuralFeature) {
            FacetStructuralFeature facetStructuralFeature = (FacetStructuralFeature)structuralFeature;
            ModelQuery modelQuery = facetStructuralFeature.getValueQuery();
            AbstractModelQuery abstractModelQuery = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(modelQuery);
            return abstractModelQuery.basicEvaluate(eObject);
        }
        if (!(structuralFeature instanceof Shortcut)) throw new ModiscoFacetException("The structuralFeature parameter must be a FacetStructuralFeature: " + structuralFeature.toString());
        Shortcut shortcut = (Shortcut)structuralFeature;
        BasicEList resultList = new BasicEList();
        EReference oppositeRef = shortcut.getOppositeReference();
        EClass eClass = oppositeRef.getEContainingClass();
        List<EObject> list = this.allInstances(eClass);
        for (EObject modelElement : list) {
            EObject referedByModelElement = (EObject)modelElement.eGet((EStructuralFeature)oppositeRef);
            if (referedByModelElement != eObject) continue;
            EObject element = modelElement;
            for (EReference eReference : shortcut.getPath()) {
                element = (EObject)element.eGet((EStructuralFeature)eReference);
            }
            resultList.add(element);
        }
        if (shortcut.getUpperBound() > 1) {
            return resultList;
        }
        if (resultList.size() > 1) {
            throw new StructuralConstraintViolationException();
        }
        if (resultList.size() != 1) return result;
        return resultList.get(0);
    }

    protected List<EObject> allInstances(EClass eClass) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Resource resource : this.resources) {
            TreeIterator treeIterator = resource.getAllContents();
            while (treeIterator.hasNext()) {
                EObject eObject = (EObject)treeIterator.next();
                if (!eClass.isInstance((Object)eObject)) continue;
                result.add(eObject);
            }
        }
        return result;
    }

    public List<EStructuralFeature> getFacetFeatures(EObject eObject) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        for (Facet facet : this.appliedFacets) {
            try {
                if (!this.isInstance(eObject, facet)) continue;
                result.addAll((Collection<EStructuralFeature>)facet.getEStructuralFeatures());
            }
            catch (ModelQueryException e) {
                Status status = new Status(4, "org.eclipse.gmt.modisco.infra.query.core", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return result;
    }

    public void addAll(Collection<FacetSet> allFacetSets) {
        for (FacetSet facetSet : allFacetSets) {
            this.addFacetSet(facetSet);
        }
    }

    public EList<EAttribute> getAttributes(EObject eObject) throws ModelQueryException {
        BasicEList result = new BasicEList();
        for (Facet facet : this.appliedFacets) {
            if (!this.isInstance(eObject, facet)) continue;
            for (EStructuralFeature structuralFeature : facet.getEStructuralFeatures()) {
                if (!(structuralFeature instanceof FacetAttribute)) continue;
                FacetAttribute facetAttribute = (FacetAttribute)structuralFeature;
                result.add((Object)facetAttribute);
            }
        }
        return result;
    }

    public EList<EReference> getReferences(EObject eObject) throws ModelQueryException {
        BasicEList result = new BasicEList();
        for (Facet facet : this.appliedFacets) {
            if (!this.isInstance(eObject, facet)) continue;
            for (EStructuralFeature structuralFeature : facet.getEStructuralFeatures()) {
                if (!(structuralFeature instanceof FacetReference) && !(structuralFeature instanceof Shortcut)) continue;
                EReference facetAttribute = (EReference)structuralFeature;
                result.add((Object)facetAttribute);
            }
        }
        return result;
    }

    public List<EClass> getMetaClasses() {
        ArrayList<EClass> metaClasses = new ArrayList<EClass>();
        metaClasses.addAll(this.appliedFacets);
        return metaClasses;
    }

    public List<Facet> getFacets(EObject eObject) throws ModelQueryException {
        ArrayList<Facet> result = new ArrayList<Facet>();
        for (Facet facet : this.appliedFacets) {
            try {
                if (!this.isInstance(eObject, facet)) continue;
                result.add(facet);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.gmt.modisco.infra.query.core", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return result;
    }

    public HashSet<Facet> getAppliedFacets() {
        return this.appliedFacets;
    }

    public void clean() {
        this.appliedFeatures.clear();
        this.appliedFacets.clear();
    }

    protected List<EStructuralFeature> getAppliedFeatures() {
        return this.appliedFeatures;
    }
}

