/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.discoverersmanager.ui.launch;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.gmt.modisco.discoverersmanager.Discoverer;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoverersManager;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.utils.ParameterUtils;

public class DiscovererLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            String kind = configuration.getAttribute("discoverer_kind", "");
            String sourcePath = configuration.getAttribute("discoverer_source_path", "");
            Discoverer discoverer = DiscoverersManager.getDefault().getDiscoverer(kind);
            HashMap<DiscoveryParameter, Object> parameters = new HashMap<DiscoveryParameter, Object>();
            for (DiscoveryParameter parameter : discoverer.getDiscovererParameters()) {
                Object value = ParameterUtils.getInstance().deserializeParameterValue(parameter, configuration);
                if (value == null) continue;
                parameters.put(parameter, value);
            }
            Object source = this.convertSourcePath(sourcePath);
            discoverer.discoverElement(source, parameters);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.gmt.modisco.discoverersmanager", "Please, check your discoverer configuration.", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private final Object convertSourcePath(String sourcePath) {
        IProject source = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath rootPath = root.getFullPath();
        IPath path = rootPath.append(sourcePath);
        Object iproject = null;
        iproject = path.segmentCount() == 1 ? root.getProject(sourcePath) : root.getFolder(path);
        if (iproject != null && iproject.exists()) {
            source = iproject;
        } else {
            IFile ifile = root.getFile(path);
            source = ifile;
        }
        return source;
    }
}

