/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.discoverersmanager.ui.launch.parametersdisplay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.data.DiscoveryParameterDisplay;
import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.parametersdisplay.Messages;
import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.parametersdisplay.ParametersTableComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscovererParametersComposite
extends Composite {
    private Group discovererParametersGroup = null;
    private ParametersTableComposite inParametersGroup = null;
    private ParametersTableComposite inoutParametersGroup = null;
    private ParametersTableComposite outParametersGroup = null;
    private ExpandBar parametersBar = null;
    private ExpandItem inParametersItem = null;
    private ExpandItem inoutParametersItem = null;
    private ExpandItem outParametersItem = null;
    private List<DiscoveryParameterDisplay> discoveryParameters = Collections.emptyList();

    public DiscovererParametersComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private final void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.setLayoutData(gridData);
        this.setLayout((Layout)gridLayout);
        this.createDiscovererParametersGroup();
    }

    private final void createDiscovererParametersGroup() {
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessVerticalSpace = true;
        this.discovererParametersGroup = new Group((Composite)this, 0);
        this.discovererParametersGroup.setText(Messages.DiscovererParametersComposite_2);
        this.discovererParametersGroup.setLayoutData((Object)gridData1);
        this.parametersBar = new ExpandBar((Composite)this.discovererParametersGroup, 512);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.parametersBar.setLayoutData((Object)gridData);
        this.createInParametersGroup();
        this.createInoutParametersGroup();
        this.createOutParametersGroup();
        this.discovererParametersGroup.setLayout((Layout)new GridLayout());
    }

    private final void createInParametersGroup() {
        this.inParametersGroup = new ParametersTableComposite((Composite)this.parametersBar, 0, this.getInDiscoveryParameters());
        this.inParametersItem = new ExpandItem(this.parametersBar, 0, 0);
        this.inParametersItem.setText(Messages.DiscovererParametersComposite_0);
        this.inParametersItem.setHeight(this.inParametersGroup.computeSize((int)-1, (int)-1).y);
        this.inParametersItem.setControl((Control)this.inParametersGroup);
        this.inParametersItem.setExpanded(!this.getInDiscoveryParameters().isEmpty());
    }

    private final List<DiscoveryParameterDisplay> getInDiscoveryParameters() {
        ArrayList<DiscoveryParameterDisplay> inParameters = new ArrayList<DiscoveryParameterDisplay>();
        for (DiscoveryParameterDisplay parameter : this.discoveryParameters) {
            if (parameter.getParameterDirectionKind() != DiscoveryParameterDirectionKind.in) continue;
            inParameters.add(parameter);
        }
        return inParameters;
    }

    private final void createInoutParametersGroup() {
        this.inoutParametersGroup = new ParametersTableComposite((Composite)this.parametersBar, 0, this.getInOutDiscoveryParameters());
        this.inoutParametersItem = new ExpandItem(this.parametersBar, 0, 1);
        this.inoutParametersItem.setText(Messages.DiscovererParametersComposite_1);
        this.inoutParametersItem.setHeight(this.inoutParametersGroup.computeSize((int)-1, (int)-1).y);
        this.inoutParametersItem.setControl((Control)this.inoutParametersGroup);
        this.inoutParametersItem.setExpanded(!this.getInOutDiscoveryParameters().isEmpty());
    }

    private final List<DiscoveryParameterDisplay> getInOutDiscoveryParameters() {
        ArrayList<DiscoveryParameterDisplay> inoutParameters = new ArrayList<DiscoveryParameterDisplay>();
        for (DiscoveryParameterDisplay parameter : this.discoveryParameters) {
            if (parameter.getParameterDirectionKind() != DiscoveryParameterDirectionKind.inout) continue;
            inoutParameters.add(parameter);
        }
        return inoutParameters;
    }

    private final void createOutParametersGroup() {
        this.outParametersGroup = new ParametersTableComposite((Composite)this.parametersBar, 0, this.getOutDiscoveryParameters());
        this.outParametersItem = new ExpandItem(this.parametersBar, 0, 2);
        this.outParametersItem.setText(Messages.DiscovererParametersComposite_3);
        this.outParametersItem.setHeight(this.outParametersGroup.computeSize((int)-1, (int)-1).y);
        this.outParametersItem.setControl((Control)this.outParametersGroup);
        this.outParametersItem.setExpanded(!this.getOutDiscoveryParameters().isEmpty());
    }

    private final List<DiscoveryParameterDisplay> getOutDiscoveryParameters() {
        ArrayList<DiscoveryParameterDisplay> outParameters = new ArrayList<DiscoveryParameterDisplay>();
        for (DiscoveryParameterDisplay parameter : this.discoveryParameters) {
            if (parameter.getParameterDirectionKind() != DiscoveryParameterDirectionKind.out) continue;
            outParameters.add(parameter);
        }
        return outParameters;
    }

    public void updateDiscoveryParameters(List<DiscoveryParameterDisplay> displayParameters) {
        this.discoveryParameters = displayParameters;
        this.inParametersGroup.updateDisplayParameters(this.getInDiscoveryParameters());
        this.inoutParametersGroup.updateDisplayParameters(this.getInOutDiscoveryParameters());
        this.outParametersGroup.updateDisplayParameters(this.getOutDiscoveryParameters());
        this.updateParametersItems();
    }

    private final void updateParametersItems() {
        int size = this.getInDiscoveryParameters().size();
        this.inParametersItem.setExpanded(size != 0);
        if (this.inParametersItem.getExpanded()) {
            this.inParametersItem.setHeight(this.inParametersGroup.getBounds().height);
        }
        this.inoutParametersItem.setExpanded((size = this.getInOutDiscoveryParameters().size()) != 0);
        if (this.inoutParametersItem.getExpanded()) {
            this.inoutParametersItem.setHeight(this.inoutParametersGroup.getBounds().height);
        }
        this.outParametersItem.setExpanded((size = this.getOutDiscoveryParameters().size()) != 0);
        if (this.outParametersItem.getExpanded()) {
            this.outParametersItem.setHeight(this.outParametersGroup.getBounds().height);
        }
    }
}

