/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.facet.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.common.core.builder.AbstractMoDiscoCatalog;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.common.core.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetPackage;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.gmt.modisco.infra.facet.core.FacetSetCatalog;
import org.eclipse.gmt.modisco.infra.facet.ui.Activator;
import org.eclipse.gmt.modisco.infra.facet.ui.Messages;
import org.eclipse.gmt.modisco.infra.facet.ui.views.FacetSetContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class FacetView
extends ViewPart
implements AbstractMoDiscoCatalog.ModiscoCatalogChangeListener {
    private static final int JOB_SCHEDULE_DELAY = 500;
    private static final int COLUMN_WIDTH = 200;
    private TreeViewer facetSetViewer;
    private TreeViewerColumn nameColumn;
    private TreeViewerColumn locationColumn;
    private Job refreshJob = null;
    private TreeViewerColumn defaultColumn;
    private TreeViewerColumn extendsColumn;

    public TreeViewer getFacetSetViewer() {
        return this.facetSetViewer;
    }

    public TreeViewerColumn getNameColumn() {
        return this.nameColumn;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.facetSetViewer = new TreeViewer(parent, 66308);
        this.facetSetViewer.getTree().setLinesVisible(true);
        this.facetSetViewer.getTree().setHeaderVisible(true);
        this.facetSetViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)FacetView.this.getFacetSetViewer().getSelection();
                EObject modelElement = (EObject)selection.getFirstElement();
                FacetSet facetSet = null;
                if (modelElement instanceof FacetSet) {
                    facetSet = (FacetSet)modelElement;
                } else if (modelElement instanceof Facet) {
                    Facet facet = (Facet)modelElement;
                    facetSet = facet.getEPackage();
                }
                if (facetSet != null) {
                    java.net.URI uri = null;
                    try {
                        String uriString = FacetSetCatalog.getSingleton().getURI(facetSet.getName()).toString();
                        uri = java.net.URI.create(uriString);
                        if ("file".equals(uri.getScheme())) {
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (java.net.URI)new java.net.URI(facetSet.eResource().getURI().toString()), (String)Activator.FACET_EDITOR_ID, (boolean)true);
                        } else {
                            URIEditorInput uriEditorInput = new URIEditorInput(URI.createURI((String)uri.toString()));
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)uriEditorInput, (String)Activator.FACET_EDITOR_ID, (boolean)true);
                        }
                    }
                    catch (Exception e) {
                        MoDiscoLogger.logError((Throwable)e, (String)("Failed to open: " + uri), (Plugin)Activator.getDefault());
                    }
                }
            }
        });
        this.createNameColumn();
        this.createExtendsColumn();
        this.createLocationColumn();
        this.createDefaultColumn();
        this.facetSetViewer.setContentProvider((IContentProvider)new FacetSetContentProvider(FacetPackage.eINSTANCE.getFacetStructuralFeature()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.facetSetViewer);
        this.refresh(false);
        FacetSetCatalog.getSingleton().addChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    private void createLocationColumn() {
        this.locationColumn = new TreeViewerColumn(this.facetSetViewer, 0);
        this.locationColumn.getColumn().setText(Messages.FacetView_location);
        this.locationColumn.getColumn().setWidth(400);
        this.locationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof FacetSet)) {
                    return "";
                }
                FacetSet facetSet = (FacetSet)element;
                return FacetSetCatalog.getSingleton().getURI(facetSet.getName()).toString();
            }
        });
        this.addSorter(this.locationColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                FacetSet facetSet1 = (FacetSet)e1;
                FacetSet facetSet2 = (FacetSet)e2;
                String uri1 = FacetSetCatalog.getSingleton().getURI(facetSet1.getName()).toString();
                String uri2 = FacetSetCatalog.getSingleton().getURI(facetSet2.getName()).toString();
                int compare = uri1.compareTo(uri2);
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void createNameColumn() {
        this.nameColumn = new TreeViewerColumn(this.facetSetViewer, 0);
        this.nameColumn.getColumn().setText(Messages.FacetView_name);
        this.nameColumn.getColumn().setWidth(200);
        this.nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FacetSet) {
                    FacetSet facetSet = (FacetSet)element;
                    return facetSet.getName();
                }
                if (element instanceof Facet) {
                    Facet facet = (Facet)element;
                    return facet.getName();
                }
                if (element instanceof EStructuralFeature) {
                    EStructuralFeature feature = (EStructuralFeature)element;
                    return feature.getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        });
        this.addSorter(this.nameColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                FacetSet facetSet1 = (FacetSet)e1;
                FacetSet facetSet2 = (FacetSet)e2;
                int compare = facetSet1.getName().compareTo(facetSet2.getName());
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void createDefaultColumn() {
        this.defaultColumn = new TreeViewerColumn(this.facetSetViewer, 0);
        this.defaultColumn.getColumn().setText(Messages.FacetView_1);
        this.defaultColumn.getColumn().setWidth(200);
        this.defaultColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                FacetSet facetSet;
                EAnnotation annotation;
                if (element instanceof FacetSet && (annotation = (facetSet = (FacetSet)element).getEAnnotation("default")) != null && annotation.getReferences().size() == 1 && annotation.getReferences().get(0) instanceof EPackage) {
                    EPackage ePackage = (EPackage)annotation.getReferences().get(0);
                    return String.valueOf(ePackage.getName()) + " " + ePackage.getNsURI();
                }
                return "";
            }
        });
        this.addSorter(this.defaultColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                FacetSet facetSet1 = (FacetSet)e1;
                FacetSet facetSet2 = (FacetSet)e2;
                int compare = facetSet1.getName().compareTo(facetSet2.getName());
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void createExtendsColumn() {
        this.extendsColumn = new TreeViewerColumn(this.facetSetViewer, 0);
        this.extendsColumn.getColumn().setText(Messages.FacetView_3);
        this.extendsColumn.getColumn().setWidth(200);
        this.extendsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof FacetSet) {
                    FacetSet facetSet = (FacetSet)element;
                    return String.valueOf(facetSet.getExtendedPackage().getName()) + " " + facetSet.getExtendedPackage().getNsURI();
                }
                return "";
            }
        });
        this.addSorter(this.extendsColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                FacetSet facetSet1 = (FacetSet)e1;
                FacetSet facetSet2 = (FacetSet)e2;
                int compare = facetSet1.getName().compareTo(facetSet2.getName());
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void addSorter(final TreeViewerColumn column, final ViewerSorter viewerSorter) {
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeViewer treeView = FacetView.this.getFacetSetViewer();
                treeView.setSorter(viewerSorter);
                treeView.getTree().setSortColumn(column.getColumn());
                if (treeView.getTree().getSortDirection() == 128) {
                    treeView.getTree().setSortDirection(1024);
                } else if (treeView.getTree().getSortDirection() == 1024) {
                    treeView.getTree().setSortDirection(128);
                } else {
                    treeView.getTree().setSortDirection(128);
                }
                treeView.refresh();
            }
        });
    }

    public void setFocus() {
        this.facetSetViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        FacetSetCatalog.getSingleton().removeChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    public void changed(EObject changedFacetSet, IFile file) {
        this.refresh(true);
    }

    public void added(EObject addedFacetSet, IFile file) {
        this.refresh(true);
    }

    public void removed(IFile facetSetFile) {
        this.refresh(true);
    }

    private void refresh(boolean delayed) {
        if (this.refreshJob == null) {
            this.refreshJob = new Job(Messages.FacetView_JobName_refreshingFacetSetsView){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            FacetView.this.getFacetSetViewer().setInput((Object)FacetSetCatalog.getSingleton().getAllFacetSets().toArray());
                            FacetView.this.getNameColumn().getColumn().pack();
                            FacetView.this.getFacetSetViewer().refresh();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        }
        if (delayed) {
            this.refreshJob.cancel();
            this.refreshJob.setPriority(50);
            this.refreshJob.schedule(500L);
        } else {
            this.refreshJob.schedule();
            try {
                this.refreshJob.join();
            }
            catch (InterruptedException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }
}

