/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.query.JavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.ui.Messages;
import org.eclipse.gmt.modisco.infra.query.ui.exceptions.ClassAlreadyExistsException;
import org.eclipse.gmt.modisco.infra.query.ui.exceptions.ResourceURIExpectedException;
import org.eclipse.gmt.modisco.infra.query.ui.wizards.NewQueryClassWizardPage;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class NewClassCreationWizard
extends Wizard {
    private final JavaModelQuery query;
    private final IJavaProject javaProject;
    private NewQueryClassWizardPage mainPage;

    public NewClassCreationWizard(JavaModelQuery query) throws ResourceURIExpectedException, JavaModelException, ClassAlreadyExistsException {
        Resource resource = query.eResource();
        URI uri = resource.getURI();
        if (!uri.isPlatformResource()) {
            throw new ResourceURIExpectedException();
        }
        String projectName = uri.segment(1);
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject(projectName);
        this.javaProject = JavaCore.create((IProject)project);
        this.query = query;
        if (this.javaProject.findType(this.query.getImplementationClassName()) != null) {
            throw new ClassAlreadyExistsException();
        }
    }

    public void addPages() {
        this.mainPage = new NewQueryClassWizardPage(this.javaProject, this.query.getImplementationClassName());
        this.addPage((IWizardPage)this.mainPage);
        this.mainPage.init(null);
    }

    public boolean performFinish() {
        try {
            this.mainPage.createType((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewClassCreationWizard_0, (String)Messages.NewClassCreationWizard_1);
        }
        return true;
    }
}

