/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.java.discoverer.benchmark.tests;

import java.io.IOException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.FileUtils;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.RunBenchmark;
import org.eclipse.jdt.core.JavaCore;
import org.junit.Test;

public class JavaDiscovererBenchmarkTest {

	@Test
	public void test001() throws CoreException, IOException {
		IWorkspace ws = ResourcesPlugin.getWorkspace();
		IProject iProject = ws.getRoot().getProject(
				this.getClass().getName() + ".test001"); //$NON-NLS-1$
		ProjectUtils.create(iProject, new NullProgressMonitor());
		String filePath = "src/" + this.getClass().getName().replace('.', '/') + ".java";//$NON-NLS-1$ //$NON-NLS-2$
		FileUtils.copyFileFromBundle(filePath, iProject, filePath, Activator
				.getDefault().getBundle());
		new RunBenchmark().createReport(JavaCore.create(iProject));
	}
}
