/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.common.ui.internal.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.ui.Activator;
import org.eclipse.gmt.modisco.infra.query.ui.Messages;
import org.eclipse.gmt.modisco.infra.query.ui.wizards.CreateQueryWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySelectionDialog
extends Dialog {
    private Collection<ModelQuerySet> fQuerySets;
    private final ViewerFilter viewerFilter;
    private FilteredTree filteredTree;
    private final boolean multiSelection;
    private List<ModelQuery> selectedQueries;

    public QuerySelectionDialog(Shell parentShell, boolean multiSelection, Collection<ModelQuerySet> querySets, ViewerFilter viewerFilter) {
        super(parentShell);
        this.multiSelection = multiSelection;
        this.fQuerySets = querySets == null ? ModelQuerySetCatalog.getSingleton().getAllModelQuerySets() : querySets;
        this.viewerFilter = viewerFilter;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.filteredTree = QuerySelectionDialog.createFilteredTree(composite, this.fQuerySets, this.viewerFilter, this.multiSelection);
        this.createContextMenu(this.filteredTree.getViewer());
        this.filteredTree.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                QuerySelectionDialog.this.okPressed();
            }
        });
        return composite;
    }

    private void createContextMenu(final TreeViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object firstElement;
                IStructuredSelection structuredSelection;
                ISelection selection = viewer.getSelection();
                if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (firstElement = structuredSelection.getFirstElement()) instanceof ModelQuerySet) {
                    ModelQuerySet modelQuerySet = (ModelQuerySet)firstElement;
                    manager.add((IAction)new OpenCreateQueryWizardAction(modelQuerySet));
                    return;
                }
                manager.add((IAction)new OpenCreateQueryWizardAction(null));
            }
        });
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.QuerySelectionDialog_selectQuery);
        shell.setImage(ImageProvider.getInstance().getModiscoLogo());
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".settings";
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    protected void okPressed() {
        this.selectedQueries = new ArrayList<ModelQuery>();
        ISelection selection = this.filteredTree.getViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof ModelQuery)) continue;
                this.selectedQueries.add((ModelQuery)selectedElement);
            }
        }
        super.okPressed();
    }

    public List<ModelQuery> getSelectedQueries() {
        return this.selectedQueries;
    }

    public static FilteredTree createFilteredTree(Composite parentComposite, Collection<ModelQuerySet> availableQuerySets, ViewerFilter viewerFilter, boolean multiSelection) {
        PatternFilter filter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
                if (labelText == null) {
                    return false;
                }
                return this.wordMatches(labelText) || this.parentMatches(viewer, element);
            }

            private boolean parentMatches(Viewer viewer, Object element) {
                ITreeContentProvider contentProvider = (ITreeContentProvider)((StructuredViewer)viewer).getContentProvider();
                Object parent = contentProvider.getParent(element);
                if (parent == null) {
                    return false;
                }
                return this.isLeafMatch(viewer, parent);
            }
        };
        int selectionStyle = multiSelection ? 2 : 4;
        FilteredTree tree = new FilteredTree(parentComposite, selectionStyle | 0x100 | 0x200 | 0x800, filter, true);
        TreeViewer treeViewer = tree.getViewer();
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                List querySets2 = (List)inputElement;
                return querySets2.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ModelQuerySet) {
                    ModelQuerySet querySet = (ModelQuerySet)parentElement;
                    return querySet.getQueries().toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof ModelQuery) {
                    ModelQuery query = (ModelQuery)element;
                    return query.getModelQuerySet();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof ModelQuerySet) {
                    ModelQuerySet querySet = (ModelQuerySet)element;
                    return !querySet.getQueries().isEmpty();
                }
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModelQuerySet) {
                    ModelQuerySet querySet = (ModelQuerySet)element;
                    return querySet.getName();
                }
                if (element instanceof ModelQuery) {
                    ModelQuery query = (ModelQuery)element;
                    return query.getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        });
        if (viewerFilter != null) {
            treeViewer.setFilters(new ViewerFilter[]{viewerFilter});
        }
        QuerySelectionDialog.changeInput(tree, availableQuerySets);
        return tree;
    }

    public static void changeInput(FilteredTree tree, Collection<ModelQuerySet> availableQuerySets) {
        Collection querySets = availableQuerySets == null ? ModelQuerySetCatalog.getSingleton().getAllModelQuerySets() : availableQuerySets;
        tree.getViewer().setInput((Object)querySets);
    }

    private class OpenCreateQueryWizardAction
    extends Action {
        private final ModelQuerySet modelQuerySet;

        public OpenCreateQueryWizardAction(ModelQuerySet modelQuerySet) {
            this.modelQuerySet = modelQuerySet;
            this.setText(Messages.QuerySelectionDialog_createQuery);
        }

        public void run() {
            final CreateQueryWizard createQueryWizard = new CreateQueryWizard(this.modelQuerySet, null);
            WizardDialog wizardDialog = new WizardDialog(null, (IWizard)createQueryWizard);
            if (wizardDialog.open() == 0) {
                Job refreshJob = new Job(Messages.QuerySelectionDialog_refreshQuerySetsJob){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ResourcesPlugin.getWorkspace().build(6, monitor);
                        }
                        catch (CoreException e) {
                            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                        }
                        ArrayList oldQuerySets = new ArrayList(QuerySelectionDialog.this.fQuerySets);
                        final ArrayList<ModelQuerySet> newQuerySets = new ArrayList<ModelQuerySet>();
                        for (ModelQuerySet oldQuerySet : oldQuerySets) {
                            ModelQuerySet querySet = ModelQuerySetCatalog.getSingleton().getModelQuerySet(oldQuerySet.getName());
                            if (querySet == null) continue;
                            newQuerySets.add(querySet);
                        }
                        QuerySelectionDialog.this.fQuerySets = newQuerySets;
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                QuerySelectionDialog.changeInput(QuerySelectionDialog.this.filteredTree, newQuerySets);
                                ModelQuery createdModelQuery = createQueryWizard.getCreatedModelQuery();
                                ModelQuerySet querySet = ModelQuerySetCatalog.getSingleton().getModelQuerySet(createdModelQuery.getModelQuerySet().getName());
                                ModelQuery query = querySet.getQuery(createdModelQuery.getName());
                                QuerySelectionDialog.this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)query), true);
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.setPriority(50);
                refreshJob.schedule();
            }
        }
    }
}

