/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.AbstractMoDiscoCatalog;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.common.ui.internal.views.AbstractCatalogView;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.editor.presentation.QueryEditor;
import org.eclipse.gmt.modisco.infra.query.ui.Activator;
import org.eclipse.gmt.modisco.infra.query.ui.Messages;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ModelQueryView
extends AbstractCatalogView
implements AbstractMoDiscoCatalog.ModiscoCatalogChangeListener {
    private static final String NAME_COLUMN = "ModelQueryView_NameColumn";
    private static final String DESCRIPTION_COLUMN = "ModelQueryView_DescriptionColumn";
    private static final String LOCATION_COLUMN = "ModelQueryView_LocationColumn";
    private static final int COLUMN_WIDTH = 200;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ModelQuerySetCatalog.getSingleton().addChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    protected void createColumns() {
        this.createNameColumn();
        this.createDescriptionColumn();
        this.createLocationColumn();
    }

    private void createNameColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModelQuerySet) {
                    ModelQuerySet modelQuerySet = (ModelQuerySet)element;
                    return modelQuerySet.getName();
                }
                if (element instanceof ModelQuery) {
                    ModelQuery modelQuery = (ModelQuery)element;
                    return modelQuery.getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        };
        this.createColumn(Messages.ModelQueryView_name, NAME_COLUMN, 200, columnLabelProvider);
    }

    private void createDescriptionColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModelQuerySet) {
                    ModelQuerySet modelQuerySet = (ModelQuerySet)element;
                    return modelQuerySet.getDescription();
                }
                if (element instanceof ModelQuery) {
                    ModelQuery modelQuery = (ModelQuery)element;
                    return modelQuery.getDescription();
                }
                return "";
            }
        };
        this.createColumn(Messages.ModelQueryView_description, DESCRIPTION_COLUMN, 200, columnLabelProvider);
    }

    private void createLocationColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof ModelQuerySet)) {
                    return "";
                }
                ModelQuerySet modelQuerySet = (ModelQuerySet)element;
                return ModelQuerySetCatalog.getSingleton().getURI(modelQuerySet.getName()).toString();
            }
        };
        this.createColumn(Messages.ModelQueryView_location, LOCATION_COLUMN, 400, columnLabelProvider);
    }

    public void dispose() {
        super.dispose();
        ModelQuerySetCatalog.getSingleton().removeChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    public void changed(EObject changedQuerySet, IFile file) {
        this.refresh(true);
    }

    public void added(EObject addedQuerySet, IFile file) {
        this.refresh(true);
    }

    public void removed(IFile querySetFile) {
        this.refresh(true);
    }

    protected IContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (!(inputElement instanceof Object[])) {
                    throw new RuntimeException("Unexpected inputElement type: " + inputElement.getClass().getName());
                }
                return (Object[])inputElement;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getChildren(Object parentElement) {
                if (!(parentElement instanceof ModelQuerySet)) {
                    throw new RuntimeException("Unexpected inputElement type: " + parentElement.getClass().getName());
                }
                ModelQuerySet modelQuerySet = (ModelQuerySet)parentElement;
                return modelQuerySet.getQueries().toArray();
            }

            public Object getParent(Object element) {
                if (element instanceof ModelQuerySet) {
                    return null;
                }
                if (element instanceof ModelQuery) {
                    ModelQuery modelQuery = (ModelQuery)element;
                    return modelQuery.getModelQuerySet();
                }
                throw new RuntimeException("Unexpected inputElement type: " + element.getClass().getName());
            }

            public boolean hasChildren(Object element) {
                return element instanceof ModelQuerySet && this.getChildren(element).length > 0;
            }

            public void dispose() {
            }
        };
    }

    protected void openElement(Object element) {
        EObject modelElement = (EObject)element;
        ModelQuerySet modelQuerySet = null;
        if (modelElement instanceof ModelQuerySet) {
            modelQuerySet = (ModelQuerySet)modelElement;
        } else if (modelElement instanceof ModelQuery) {
            ModelQuery modelQuery = (ModelQuery)modelElement;
            modelQuerySet = modelQuery.getModelQuerySet();
        }
        if (modelQuerySet != null) {
            java.net.URI uri = null;
            try {
                String uriString = ModelQuerySetCatalog.getSingleton().getURI(modelQuerySet.getName()).toString();
                uri = java.net.URI.create(uriString);
                IEditorPart editor = null;
                if ("file".equals(uri.getScheme())) {
                    editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (java.net.URI)new java.net.URI(modelQuerySet.eResource().getURI().toString()), (String)"org.eclipse.gmt.modisco.infra.query.emf.presentation.queryEditorID", (boolean)true);
                } else {
                    URIEditorInput uriEditorInput = new URIEditorInput(URI.createURI((String)uri.toString()));
                    editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)uriEditorInput, (String)"org.eclipse.gmt.modisco.infra.query.emf.presentation.queryEditorID", (boolean)true);
                }
                if (editor instanceof QueryEditor) {
                    QueryEditor queryEditor = (QueryEditor)editor;
                    queryEditor.setSelectionToViewer(modelElement);
                }
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (String)("Failed to open: " + uri), (Plugin)Activator.getDefault());
            }
        }
    }

    protected String getRefreshMessage() {
        return Messages.refreshingQuerySetsView;
    }

    protected void doRefresh() {
        this.getViewer().setInput((Object)ModelQuerySetCatalog.getSingleton().getAllModelQuerySets().toArray());
        this.getViewer().refresh();
    }
}

