/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.ui.wizards;

import java.util.Collections;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.gmt.modisco.infra.query.QueryFactory;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.ui.Activator;
import org.eclipse.gmt.modisco.infra.query.ui.wizards.CreateQueryWizardPage;
import org.eclipse.gmt.modisco.infra.query.ui.wizards.NewQueryClassWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class CreateQueryWizard
extends Wizard {
    private final ModelQuerySet modelQuerySet;
    private final EClass eClass;
    private CreateQueryWizardPage createQueryWizardPage;
    private NewQueryClassWizardPage newQueryClassWizardPage;
    private ModelQuery modelQuery;

    public CreateQueryWizard(ModelQuerySet modelQuerySet, EClass eClass) {
        this.modelQuerySet = modelQuerySet;
        this.eClass = eClass;
        this.setHelpAvailable(false);
    }

    public void addPages() {
        this.createQueryWizardPage = new CreateQueryWizardPage(this.modelQuerySet, this.eClass);
        this.newQueryClassWizardPage = new NewQueryClassWizardPage();
        this.addPage((IWizardPage)this.createQueryWizardPage);
        this.addPage(this.newQueryClassWizardPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.createQueryWizardPage) {
            this.createQuery();
            ModelQuerySet querySet = this.createQueryWizardPage.getQuerySet();
            if (querySet != null) {
                this.newQueryClassWizardPage.init(querySet, this.modelQuery);
            }
            return this.newQueryClassWizardPage;
        }
        return null;
    }

    private void createQuery() {
        this.modelQuery = QueryFactory.eINSTANCE.createJavaModelQuery();
        this.modelQuery.setName(this.createQueryWizardPage.getQueryName());
        this.modelQuery.setDescription(this.createQueryWizardPage.getQueryDescription());
        this.modelQuery.getScope().addAll(this.createQueryWizardPage.getScope());
        this.modelQuery.setReturnType(this.createQueryWizardPage.getReturnType());
        this.modelQuery.setLowerBound(0);
        if (this.createQueryWizardPage.isReturnTypeMultiValued()) {
            this.modelQuery.setUpperBound(-1);
        } else {
            this.modelQuery.setUpperBound(1);
        }
    }

    public boolean performFinish() {
        try {
            this.createQuery();
            this.newQueryClassWizardPage.apply(this.modelQuery);
            ModelQuerySet catalogQuerySet = this.createQueryWizardPage.getQuerySet();
            String querySetName = catalogQuerySet.getName();
            URI uri = ModelQuerySetCatalog.getSingleton().getURI(querySetName);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(uri);
            resource.load(Collections.emptyMap());
            ModelQuerySet querySet = (ModelQuerySet)resource.getContents().get(0);
            querySet.getQueries().add((Object)this.modelQuery);
            EPackage returnTypePackage = this.modelQuery.getReturnType().getEPackage();
            querySet.getAssociatedMetamodels().add((Object)returnTypePackage);
            EList scope = this.modelQuery.getScope();
            for (EClass scopeElement : scope) {
                querySet.getAssociatedMetamodels().add((Object)scopeElement.getEPackage());
            }
            resource.save(Collections.emptyMap());
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return false;
        }
        return true;
    }

    public ModelQuery getCreatedModelQuery() {
        return this.modelQuery;
    }
}

