/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.ui.views;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.gmt.modisco.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.Activator;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.Messages;
import org.eclipse.gmt.modisco.infra.browser.util.ColorProvider;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.common.ui.internal.views.AbstractCatalogView;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class CustomizationsView
extends AbstractCatalogView
implements CustomizationsCatalog.CustomizationChangeListener {
    private static final String NAME_COLUMN = "CustomizationsView_NameColumn";
    private static final String METAMODEL_COLUMN = "CustomizationsView_MetamodelColumn";
    private static final String QUERY_SETS_COLUMN = "CustomizationsView_QuerySetsColumn";
    private static final int QUERY_SETS_COLUMN_WIDTH = 400;
    private static final int METAMODEL_COLUMN_WIDTH = 300;
    private static final int NAME_COLUMN_WIDTH = 200;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        CustomizationsCatalog.getInstance().addChangeListener((CustomizationsCatalog.CustomizationChangeListener)this);
    }

    public void dispose() {
        super.dispose();
        CustomizationsCatalog.getInstance().removeChangeListener((CustomizationsCatalog.CustomizationChangeListener)this);
    }

    public void changed(MetamodelView changedCustomization, IFile file) {
        this.refresh(true);
    }

    public void added(MetamodelView addedCustomization, IFile file) {
        this.refresh(true);
    }

    public void removed(IFile customizationFile) {
        this.refresh(true);
    }

    protected void createColumns() {
        this.createNameColumn();
        this.createMetamodelColumn();
        this.createQuerySetsColumn();
    }

    private void createNameColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                MetamodelView metamodelView = (MetamodelView)element;
                return metamodelView.getName();
            }

            public Color getForeground(Object element) {
                MetamodelView metamodelView = (MetamodelView)element;
                if (!metamodelView.getLocation().startsWith("file:/")) {
                    return ColorProvider.getInstance().getExternalResourceColor();
                }
                return super.getForeground(element);
            }

            public Image getImage(Object element) {
                return ImageProvider.getInstance().getUiCustomIcon();
            }
        };
        this.createColumn(Messages.CustomizationsView_nameColumn, NAME_COLUMN, 200, columnLabelProvider);
    }

    private void createMetamodelColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                MetamodelView metamodelView = (MetamodelView)element;
                return metamodelView.getMetamodelURI();
            }
        };
        this.createColumn(Messages.CustomizationsView_metamodelColumn, METAMODEL_COLUMN, 300, columnLabelProvider);
    }

    private void createQuerySetsColumn() {
        ColumnLabelProvider columnLabelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                MetamodelView metamodelView = (MetamodelView)element;
                if (metamodelView.isAllQuerySetsAvailable()) {
                    return Messages.CustomizationsView_allQuerySets;
                }
                EList availableQuerySets = metamodelView.getAvailableQuerySets();
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while (i < availableQuerySets.size()) {
                    builder.append((String)availableQuerySets.get(i));
                    if (i != availableQuerySets.size() - 1) {
                        builder.append(", ");
                    }
                    ++i;
                }
                return builder.toString();
            }
        };
        this.createColumn(Messages.CustomizationsView_querySetsColumn, QUERY_SETS_COLUMN, 400, columnLabelProvider);
    }

    protected IContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                List metamodelViews = (List)inputElement;
                return metamodelViews.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        };
    }

    protected void openElement(Object element) {
        MetamodelView metamodelView = (MetamodelView)element;
        try {
            java.net.URI uri = new java.net.URI(metamodelView.getLocation());
            if ("file".equals(uri.getScheme())) {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (java.net.URI)new java.net.URI(metamodelView.getLocation()), (String)"org.eclipse.gmt.modisco.infra.browser.custom.editor", (boolean)true);
            } else {
                URIEditorInput uriEditorInput = new URIEditorInput(URI.createURI((String)uri.toString()));
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)uriEditorInput, (String)"org.eclipse.gmt.modisco.infra.browser.custom.editor", (boolean)true);
            }
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    protected String getRefreshMessage() {
        return Messages.CustomizationsView_jobName_RefreshCustomizationsView;
    }

    protected void doRefresh() {
        this.getViewer().setInput((Object)CustomizationsCatalog.getInstance().getAllCustomizations());
        this.getViewer().refresh();
    }
}

