/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.generator;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.strategy.DefaultStrategy;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.resource.EMtlResourceFactoryImpl;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.ModiscoworkflowPackage;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.expressions.ExpressionsPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateDiscoverer {
    public static final String MODULE_FILE_NAME = "generateDiscoverer";
    public static final String[] TEMPLATE_NAMES = new String[]{"generateDiscoverer"};
    private Module module;
    private EObject model;
    private File targetFolder;
    List<? extends Object> arguments;
    private List<IAcceleoTextGenerationListener> generationListeners = new ArrayList<IAcceleoTextGenerationListener>();
    private List<String> propertiesFiles = new ArrayList<String>();

    public GenerateDiscoverer(URI modelURI, File targetFolder, List<? extends Object> arguments) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.registerResourceFactories((ResourceSet)resourceSet);
        this.registerPackages((ResourceSet)resourceSet);
        URI templateURI = null;
        String path = this.getClass().getPackage().getName().replaceAll("\\.", "/");
        templateURI = URI.createPlatformPluginURI((String)("/org.eclipse.gmt.modisco.workflow/bin/" + path + "/" + MODULE_FILE_NAME + ".emtl"), (boolean)false);
        this.module = (Module)this.load(templateURI, (ResourceSet)resourceSet);
        this.model = this.load(modelURI, (ResourceSet)resourceSet);
        this.targetFolder = targetFolder;
        this.arguments = arguments;
    }

    public GenerateDiscoverer(EObject model, File targetFolder, List<? extends Object> arguments) throws IOException {
        URL resourceURL;
        ResourceSet resourceSet = model.eResource().getResourceSet();
        this.registerResourceFactories(resourceSet);
        this.registerPackages(resourceSet);
        this.addListeners();
        this.addProperties();
        URL templateURL = EMFPlugin.IS_ECLIPSE_RUNNING ? ((resourceURL = GenerateDiscoverer.class.getResource("generateDiscoverer.emtl")) != null ? FileLocator.toFileURL((URL)resourceURL) : null) : GenerateDiscoverer.class.getResource("generateDiscoverer.emtl");
        if (templateURL == null) {
            throw new IOException("'generateDiscoverer.emtl' not found");
        }
        URI templateURI = this.createTemplateURI(templateURL.getPath());
        this.module = (Module)this.load(templateURI, resourceSet);
        this.model = model;
        this.targetFolder = targetFolder;
        this.arguments = arguments;
    }

    protected URI createTemplateURI(String entry) {
        return URI.createFileURI((String)URI.decode((String)entry));
    }

    public EObject getModel() {
        return this.model;
    }

    private void registerPackages(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)ModiscoworkflowPackage.eINSTANCE.getNsURI(), (Object)ModiscoworkflowPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)ExpressionsPackage.eINSTANCE.getNsURI(), (Object)ExpressionsPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)MtlPackage.eINSTANCE.getNsURI(), (Object)MtlPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore", (Object)this.getOCLStdLibPackage());
    }

    private EPackage getOCLStdLibPackage() {
        EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory();
        EcoreEnvironment environment = (EcoreEnvironment)factory.createEnvironment();
        return (EPackage)EcoreUtil.getRootContainer((EObject)((EObject)environment.getOCLStandardLibrary().getBag()));
    }

    private void registerResourceFactories(ResourceSet resourceSet) {
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emtl", new EMtlResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                System.out.println("Arguments not valid : {model, folder}.");
            } else {
                URI modelURI = URI.createFileURI((String)args[0]);
                File folder = new File(args[1]);
                ArrayList<String> arguments = new ArrayList<String>();
                int i = 2;
                while (i < args.length) {
                    arguments.add(args[i]);
                    ++i;
                }
                GenerateDiscoverer generator = new GenerateDiscoverer(modelURI, folder, arguments);
                generator.doGenerate((Monitor)new BasicMonitor());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void doGenerate(Monitor monitor) throws IOException {
        if (!this.targetFolder.exists()) {
            this.targetFolder.mkdirs();
        }
        AcceleoService service = new AcceleoService(this.getGenerationStrategy());
        this.registerListeners(service);
        this.registerProperties(service);
        int i = 0;
        while (i < TEMPLATE_NAMES.length) {
            service.doGenerate(this.module, TEMPLATE_NAMES[i], this.model, this.arguments, this.targetFolder, monitor);
            ++i;
        }
        service.dispose();
    }

    public IAcceleoGenerationStrategy getGenerationStrategy() {
        return new DefaultStrategy();
    }

    private EObject load(URI modelURI, ResourceSet resourceSet) throws IOException {
        EObject result = null;
        Resource modelResource = this.createResource(modelURI, resourceSet);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty("file.encoding"));
        modelResource.load(options);
        if (modelResource.getContents().size() > 0) {
            result = (EObject)modelResource.getContents().get(0);
        }
        return result;
    }

    private Resource createResource(URI modelURI, ResourceSet resourceSet) {
        Resource.Factory.Registry registry;
        Object resourceFactory;
        String fileExtension = modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = (registry = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        }
        return resourceSet.createResource(modelURI);
    }

    private void addListeners() {
    }

    private void addProperties() {
    }

    private void registerListeners(AcceleoService service) {
        for (IAcceleoTextGenerationListener listener : this.generationListeners) {
            service.addListener(listener);
        }
    }

    private void registerProperties(AcceleoService service) {
        try {
            for (String propertyFile : this.propertiesFiles) {
                service.addPropertiesFile(propertyFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

