/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui;

import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.ui.MoDiscoExportTab;
import org.eclipse.gmt.modisco.workflow.ui.MoDiscoWorkflowCommonTab;
import org.eclipse.gmt.modisco.workflow.ui.WorkflowTransformationTab;
import org.eclipse.gmt.modisco.workflow.ui.common.Common;

public class MoDiscoWorkflowTabGroup
extends AbstractLaunchConfigurationTabGroup {
    private WorkflowTransformationTab wfTab;
    private MoDiscoExportTab export;
    private MoDiscoWorkflowCommonTab common;

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        this.wfTab = new WorkflowTransformationTab();
        this.export = new MoDiscoExportTab();
        this.common = new MoDiscoWorkflowCommonTab();
        this.setTabs(new ILaunchConfigurationTab[]{this.wfTab, this.export, this.common});
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.common.initializeFrom(configuration);
        this.wfTab.setResourcePath(this.common.getResourcePath());
        this.wfTab.initializeFrom(configuration);
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(new ILaunchConfigurationListener(){

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
                String resourcePath = null;
                if (!configuration.isLocal()) {
                    IPath path = configuration.getFile().getLocation().removeLastSegments(1).append(configuration.getName()).addFileExtension("workflow");
                    resourcePath = path.toString();
                } else {
                    resourcePath = Activator.getDefault().getStateLocation().append(configuration.getName()).addFileExtension("workflow").toString();
                }
                MoDiscoWorkflowTabGroup.this.wfTab.getController().removeResource(resourcePath);
            }
        });
        this.export.initializeFrom(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.wfTab.getController().changeWorkflowEngine(configuration);
        super.performApply(configuration);
        this.wfTab.getController().saveWorkflowResource(configuration, false);
        this.wfTab.getController().moveWorkflowResource(this.common.getResourcePath());
        if (!configuration.getOriginal().getName().equals(configuration.getName())) {
            String resourcePath = null;
            if (!configuration.isLocal()) {
                IPath path = configuration.getFile().getLocation().removeLastSegments(1).append(configuration.getName()).addFileExtension("workflow");
                resourcePath = path.toString();
            } else {
                resourcePath = Activator.getDefault().getStateLocation().append(configuration.getName()).addFileExtension("workflow").toString();
            }
            this.wfTab.getController().moveWorkflowResource(resourcePath);
        }
        Common.getInstance().refreshPackageExplorer();
    }
}

