/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.emfstat;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emfstat.Statistics;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.gmt.modisco.java.io.java.JavaReader;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;

public class JavaReaderEMFStat
extends JavaReader {
    private Statistics statistics;

    public JavaReaderEMFStat(JavaFactory factory, boolean isIncrementalDiscovering) {
        super(factory, isIncrementalDiscovering);
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    protected Statistics getStatistics() {
        return this.statistics;
    }

    public void readModel(Object source, Model resultModel1, IProgressMonitor monitor) {
        if (this.statistics != null) {
            this.statistics.beginDiscovery();
        }
        super.readModel(source, resultModel1, monitor);
        if (this.statistics != null) {
            this.statistics.endDiscovery();
        }
    }

    protected void parsePackage(IJavaProject javaProject, Model resultModel1, IPackageFragment parent, IProgressMonitor monitor) throws JavaModelException {
        if (this.statistics != null) {
            this.statistics.tabValueReport("New non empty package fragment");
            this.statistics.newPackage(parent);
        }
        super.parsePackage(javaProject, resultModel1, parent, monitor);
    }

    protected void parseTypeRoot(ITypeRoot cu) {
        if (this.statistics != null) {
            this.statistics.newCompilationUnit(cu);
            this.statistics.tabValueReport("New cu");
        }
        super.parseTypeRoot(cu);
    }

    protected void finalResolveBindings(Model resultModel1) {
        super.finalResolveBindings(resultModel1);
        if (this.statistics != null) {
            this.statistics.tabValueReport("globalBindings resolved");
        }
    }
}

