/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.common.core.internal.resource.IMoDiscoResourceListener;
import org.eclipse.gmt.modisco.infra.common.core.internal.resource.MoDiscoResourceSet;

public class MoDiscoResourceListenerGroup {
    private final Map<IMoDiscoResourceListener, URI> listeners = new HashMap<IMoDiscoResourceListener, URI>();
    private final URI watchedResourceUri;

    public MoDiscoResourceListenerGroup(URI watchedResourceUri) {
        this.watchedResourceUri = watchedResourceUri;
        if (MoDiscoResourceSet.DEBUG) {
            Status status = new Status(1, "org.eclipse.gmt.modisco.infra.common.core", "[" + this.getClass().getSimpleName() + "." + this.getClass().getSimpleName() + "()] " + this.watchedResourceUri);
            CommonModiscoActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    public void notifyChange() {
        if (MoDiscoResourceSet.DEBUG) {
            Status status = new Status(1, "org.eclipse.gmt.modisco.infra.common.core", "[" + this.getClass().getSimpleName() + ".notifyChange()] " + this.watchedResourceUri + " nbListeners=" + this.listeners.size());
            CommonModiscoActivator.getDefault().getLog().log((IStatus)status);
        }
        for (IMoDiscoResourceListener listener : this.listeners.keySet()) {
            try {
                listener.aListenedResourceHasChanged(this.watchedResourceUri, this.listeners.get(listener));
            }
            catch (Exception e) {
                MoDiscoLogger.logError(e, "An exception happened while notifying change of: " + this.watchedResourceUri + " to: " + listener, (Plugin)CommonModiscoActivator.getDefault());
            }
        }
    }

    public void addListener(IMoDiscoResourceListener listener, URI resourceUri) {
        this.listeners.put(listener, resourceUri);
    }
}

