/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.utils;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;

public final class ValidationUtils {
    public static final String EMF_PROBLEM_MARKER = "org.eclipse.emf.ecore.diagnostic";

    private ValidationUtils() {
    }

    public static synchronized boolean validate(Resource resource, IResource file) throws CoreException {
        if (file != null) {
            file.deleteMarkers(null, true, 2);
        }
        boolean result = true;
        for (EObject eObject : resource.getContents()) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
            if (diagnostic.getSeverity() == 0) continue;
            boolean bl = result = diagnostic.getSeverity() < 4;
            if (file != null) {
                ValidationUtils.convertDiagnosticToMarker(file, diagnostic);
                continue;
            }
            ValidationUtils.convertDiagnosticToLog(resource, diagnostic);
        }
        return result;
    }

    private static void convertDiagnosticToLog(Resource resource, Diagnostic diagnostic) {
        if (diagnostic.getChildren().size() > 0) {
            for (Diagnostic subDiagnostic : diagnostic.getChildren()) {
                ValidationUtils.convertDiagnosticToLog(resource, subDiagnostic);
            }
        } else {
            Status status = null;
            String pluginId = resource.getURI().segment(1);
            if (diagnostic.getSeverity() == 4) {
                status = new Status(4, pluginId, diagnostic.getMessage());
            } else if (diagnostic.getSeverity() == 2) {
                status = new Status(2, pluginId, diagnostic.getMessage());
            } else if (diagnostic.getSeverity() == 1) {
                status = new Status(1, pluginId, diagnostic.getMessage());
            }
            CommonModiscoActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    private static void convertDiagnosticToMarker(IResource file, Diagnostic diagnostic) throws CoreException {
        if (diagnostic.getChildren().size() > 0) {
            for (Diagnostic subDiagnostic : diagnostic.getChildren()) {
                ValidationUtils.convertDiagnosticToMarker(file, subDiagnostic);
            }
        } else {
            IMarker marker = file.createMarker(EMF_PROBLEM_MARKER);
            marker.setAttribute("message", (Object)diagnostic.getMessage());
            if (diagnostic.getSeverity() == 4) {
                marker.setAttribute("severity", 2);
            } else if (diagnostic.getSeverity() == 2) {
                marker.setAttribute("severity", 1);
            } else if (diagnostic.getSeverity() == 1) {
                marker.setAttribute("severity", 0);
            }
            marker.setAttribute("location", (Object)diagnostic.getSource());
        }
    }
}

