/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.facet.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.EcoreCatalog;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.gmt.modisco.infra.facet.core.internal.Activator;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetSetCatalog
extends EcoreCatalog {
    private static final String REGISTRATION_EXTENSION_POINT_ID = "org.eclipse.gmt.modisco.infra.facet.registration";
    private static FacetSetCatalog singleton = null;
    private HashMap<EPackage, HashSet<FacetSet>> ePackageToDefaultFacetSetMap;

    public static FacetSetCatalog getSingleton() {
        if (singleton == null) {
            EcoreCatalog.getSingleton();
            ModelQuerySetCatalog.getSingleton();
            singleton = new FacetSetCatalog();
        }
        return singleton;
    }

    public HashMap<EPackage, HashSet<FacetSet>> getEPackageToDefaultFacetSetMap() {
        if (this.ePackageToDefaultFacetSetMap == null) {
            this.ePackageToDefaultFacetSetMap = new HashMap();
        }
        return this.ePackageToDefaultFacetSetMap;
    }

    private FacetSetCatalog() {
    }

    protected String getRootObjectName(EObject rootObject) {
        return ((FacetSet)rootObject).getName();
    }

    protected String getRootObjectNsUri(EObject rootObject) {
        return ((FacetSet)rootObject).getNsURI();
    }

    protected Class<?> getRootClass() {
        return FacetSet.class;
    }

    public FacetSet getFacetSet(String name) {
        return (FacetSet)this.getRootObject(name);
    }

    public HashSet<FacetSet> getDefaultFacetSets(EPackage ePackage) {
        return this.getEPackageToDefaultFacetSetMap().get(ePackage);
    }

    protected String getRegistryExtensionPoint() {
        return REGISTRATION_EXTENSION_POINT_ID;
    }

    public Collection<FacetSet> getAllFacetSets() {
        ArrayList<FacetSet> result = new ArrayList<FacetSet>();
        for (EObject eObject : this.getAllRootObjects()) {
            if (!(eObject instanceof FacetSet)) continue;
            FacetSet facetSet = (FacetSet)eObject;
            result.add(facetSet);
        }
        return result;
    }

    protected String getMoDiscoSubProtocol() {
        return "facet";
    }

    protected EObject openResource(URI uri, IResource file) {
        FacetSet facetSet;
        EAnnotation annotation;
        EObject result = super.openResource(uri, file);
        if (result instanceof FacetSet && (annotation = (facetSet = (FacetSet)result).getEAnnotation("default")) != null && annotation.getReferences().size() == 1 && annotation.getReferences().get(0) instanceof EPackage) {
            EPackage ePackage = (EPackage)annotation.getReferences().get(0);
            HashSet<Object> facetSets = this.getEPackageToDefaultFacetSetMap().get(ePackage);
            if (facetSets == null) {
                facetSets = new HashSet();
                this.getEPackageToDefaultFacetSetMap().put(ePackage, facetSets);
            }
            facetSets.add(facetSet);
        }
        return result;
    }

    protected Plugin getActivator() {
        return Activator.getDefault();
    }

    public static /* bridge */ /* synthetic */ EcoreCatalog getSingleton() {
        return FacetSetCatalog.getSingleton();
    }
}

