/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.ui.internal.views;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.common.ui.internal.MoDiscoCommonUIPlugin;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractCatalogView
extends ViewPart {
    private static final Map<String, Integer> COLUMN_WIDTHS = new HashMap<String, Integer>();
    private static final int JOB_SCHEDULE_DELAY = 500;
    private Job refreshJob = null;
    private TreeViewer treeViewer;

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer(parent, 66308);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AbstractCatalogView.this.getViewer().getSelection();
                AbstractCatalogView.this.openElement(selection.getFirstElement());
            }
        });
        this.createColumns();
        this.treeViewer.setContentProvider(this.getContentProvider());
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.refresh(false);
    }

    protected void createContextMenu() {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = contextMenu.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.getViewer());
    }

    protected abstract void createColumns();

    protected abstract IContentProvider getContentProvider();

    protected abstract void openElement(Object var1);

    protected void createColumn(String columnText, final String uniqueID, int defaultWidth, final ColumnLabelProvider columnLabelProvider) {
        final TreeViewerColumn viewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        viewerColumn.getColumn().setText(columnText);
        Integer width = COLUMN_WIDTHS.get(uniqueID);
        if (width != null) {
            viewerColumn.getColumn().setWidth(width.intValue());
        } else {
            viewerColumn.getColumn().setWidth(defaultWidth);
        }
        viewerColumn.getColumn().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                COLUMN_WIDTHS.put(uniqueID, viewerColumn.getColumn().getWidth());
            }
        });
        viewerColumn.setLabelProvider((CellLabelProvider)columnLabelProvider);
        this.addSorter(viewerColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                String text1 = columnLabelProvider.getText(e1);
                String text2 = columnLabelProvider.getText(e2);
                if (text1 == null) {
                    return -1;
                }
                int compare = text1.compareTo(text2);
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void addSorter(final TreeViewerColumn column, final ViewerSorter viewerSorter) {
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeViewer treeView = AbstractCatalogView.this.getViewer();
                treeView.setSorter(viewerSorter);
                treeView.getTree().setSortColumn(column.getColumn());
                if (treeView.getTree().getSortDirection() == 128) {
                    treeView.getTree().setSortDirection(1024);
                } else if (treeView.getTree().getSortDirection() == 1024) {
                    treeView.getTree().setSortDirection(128);
                } else {
                    treeView.getTree().setSortDirection(128);
                }
                treeView.refresh();
            }
        });
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    protected void refresh(boolean delayed) {
        if (this.refreshJob == null) {
            this.refreshJob = new Job(this.getRefreshMessage()){

                protected IStatus run(IProgressMonitor monitor) {
                    AbstractCatalogView.this.refreshJob();
                    return Status.OK_STATUS;
                }
            };
        }
        this.refreshJob.cancel();
        if (delayed) {
            this.refreshJob.setPriority(50);
            this.refreshJob.schedule(500L);
        } else {
            this.refreshJob.setPriority(10);
            this.refreshJob.schedule();
        }
    }

    protected void refreshJob() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                AbstractCatalogView.this.doRefresh();
            }
        });
    }

    protected abstract String getRefreshMessage();

    protected abstract void doRefresh();

    public void saveState(IMemento memento) {
        super.saveState(memento);
        try {
            Set<Map.Entry<String, Integer>> entrySet = COLUMN_WIDTHS.entrySet();
            for (Map.Entry<String, Integer> entry : entrySet) {
                memento.putInteger(entry.getKey(), entry.getValue().intValue());
            }
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Error saving view state", (Plugin)MoDiscoCommonUIPlugin.getDefault());
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            String[] attributeKeys;
            String[] stringArray = attributeKeys = memento.getAttributeKeys();
            int n = attributeKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                COLUMN_WIDTHS.put(key, memento.getInteger(key));
                ++n2;
            }
        }
    }
}

