/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.kdm.uml2converter;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.Tools;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.UriUtils;
import org.eclipse.gmt.modisco.kdm.uml2converter.KdmToUmlConverterInterface;
import org.eclipse.gmt.modisco.kdm.uml2converter.Messages;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.core.ui.vm.asm.ASMModelWrapper;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.parser.AtlParser;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class KDMtoUML2Converter
implements KdmToUmlConverterInterface {
    public final String mmLocation = "resources/metamodels";
    public final String transfoLocation = "resources/transformations";
    public final String kdmMMUri = "http://www.eclipse.org/MoDisco/kdm/action";
    public final String umlMMUri = "http://www.eclipse.org/uml2/2.1.0/UML";
    private final String atlMMPath = "http://www.eclipse.org/gmt/2005/ATL";

    public Resource[] getUML2ModelFromKDMModel(Resource kdmModelUri, boolean generateTraces, URI umlTargetModelUri) throws IOException, ATLCoreException {
        URL transformation = generateTraces ? this.getClass().getResource(String.valueOf("resources/transformations") + "/KDMtoUMLWithTraces.asm") : this.getClass().getResource(String.valueOf("resources/transformations") + "/KDMtoUML.asm");
        return this.getUML2ModelFromKDMModelWithCustomTransformation(kdmModelUri.getURI(), generateTraces, transformation, umlTargetModelUri);
    }

    public Resource[] getUML2ModelFromKDMModelWithCustomTransformation(URI kdmSourceModelUri, boolean generateTraces, final URL transformation, URI umlTargetModelUri) throws IOException, ATLCoreException {
        ASMModelWrapper wrapper;
        ASMModel model;
        ASMModelWrapper wrapper2;
        ASMModel model2;
        HashMap<String, String> modelHandlers = new HashMap<String, String>();
        String umlMetaModelName = "uml";
        modelHandlers.put(umlMetaModelName, "UML2");
        String kdmMetaModelName = "kdm";
        modelHandlers.put(kdmMetaModelName, "EMF");
        String amwMetaModelName = "Trace";
        if (generateTraces) {
            modelHandlers.put(amwMetaModelName, "EMF");
        }
        HashMap<String, HashMap<String, String>> launcherOptions = new HashMap<String, HashMap<String, String>>();
        launcherOptions.put("modelHandlers", modelHandlers);
        String launcherName = "Regular VM";
        final ILauncher launcher = CoreService.getLauncher((String)launcherName);
        launcher.initialize(launcherOptions);
        ModelFactory emfFactory = CoreService.createModelFactory((String)launcher.getDefaultModelFactoryName());
        IInjector emfInjector = CoreService.getInjector((String)emfFactory.getDefaultInjectorName());
        IExtractor emfExtractor = CoreService.getExtractor((String)emfFactory.getDefaultExtractorName());
        ModelFactory umlFactory = emfFactory;
        IInjector umlInjector = CoreService.getInjector((String)umlFactory.getDefaultInjectorName());
        IExtractor umlExtractor = CoreService.getExtractor((String)umlFactory.getDefaultExtractorName());
        HashMap referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(kdmMetaModelName));
        referenceModelOptions.put("modelName", kdmMetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/MoDisco/kdm/action");
        IReferenceModel kdmMM = emfFactory.newReferenceModel(referenceModelOptions);
        emfInjector.inject((IModel)kdmMM, "http://www.eclipse.org/MoDisco/kdm/action");
        HashMap<String, Object> modelOptions = new HashMap<String, Object>();
        String inModelName = "kdmInput";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)kdmSourceModelUri));
        modelOptions.put("newModel", false);
        IModel input = emfFactory.newModel(kdmMM, modelOptions);
        emfInjector.inject(input, UriUtils.toString((URI)kdmSourceModelUri));
        launcher.addInModel(input, inModelName, kdmMetaModelName);
        referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(umlMetaModelName));
        referenceModelOptions.put("modelName", umlMetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/uml2/2.1.0/UML");
        IReferenceModel umlMM = umlFactory.newReferenceModel(referenceModelOptions);
        umlInjector.inject((IModel)umlMM, "http://www.eclipse.org/uml2/2.1.0/UML");
        modelOptions = new HashMap();
        inModelName = "umlOutput";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)umlTargetModelUri));
        modelOptions.put("newModel", true);
        IModel outputInstance = umlFactory.newModel(umlMM, modelOptions);
        launcher.addOutModel(outputInstance, inModelName, umlMetaModelName);
        IModel traceInstance = null;
        if (generateTraces) {
            ModelFactory amwFactory = emfFactory;
            IInjector amwInjector = CoreService.getInjector((String)amwFactory.getDefaultInjectorName());
            CoreService.getExtractor((String)amwFactory.getDefaultExtractorName());
            URL mmwMMURL = this.getClass().getResource(String.valueOf("resources/metamodels") + "/mmw_traceability.ecore");
            referenceModelOptions = new HashMap();
            referenceModelOptions.put("modelHandlerName", modelHandlers.get(amwMetaModelName));
            referenceModelOptions.put("modelName", amwMetaModelName);
            referenceModelOptions.put("path", mmwMMURL.toString());
            IReferenceModel amwMM = amwFactory.newReferenceModel(referenceModelOptions);
            amwInjector.inject((IModel)amwMM, mmwMMURL.openStream(), Collections.EMPTY_MAP);
            modelOptions = new HashMap();
            inModelName = "trace";
            modelOptions.put("modelName", inModelName);
            modelOptions.put("path", UriUtils.toString((URI)umlTargetModelUri.trimFileExtension().appendFileExtension("trace.amw")));
            modelOptions.put("newModel", true);
            traceInstance = amwFactory.newModel(amwMM, modelOptions);
            launcher.addOutModel(traceInstance, inModelName, amwMetaModelName);
        }
        final HashMap<String, String> options = new HashMap<String, String>();
        options.put("continueAfterError", "true");
        options.put("printExecutionTime", "true");
        Job transformationThread = new Job(Messages.KDMtoUML2Converter_22){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    launcher.launch("run", monitor, options, new Object[]{transformation.openStream()});
                }
                catch (IOException e) {
                    result = Status.CANCEL_STATUS;
                    e.printStackTrace();
                }
                return result;
            }
        };
        transformationThread.schedule();
        try {
            transformationThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        umlExtractor.extract(outputInstance, UriUtils.toString((URI)umlTargetModelUri));
        if (generateTraces) {
            emfExtractor.extract(traceInstance, UriUtils.toString((URI)umlTargetModelUri.trimFileExtension().appendFileExtension("trace.amw")));
        }
        Resource output = null;
        if (outputInstance instanceof ASMModelWrapper && (model2 = (wrapper2 = (ASMModelWrapper)outputInstance).getAsmModel()) instanceof ASMEMFModel) {
            output = ((ASMEMFModel)model2).getExtent();
        }
        Resource outputTrace = null;
        if (generateTraces && traceInstance instanceof ASMModelWrapper && (model = (wrapper = (ASMModelWrapper)traceInstance).getAsmModel()) instanceof ASMEMFModel) {
            outputTrace = ((ASMEMFModel)model).getExtent();
        }
        return new Resource[]{output, outputTrace};
    }

    public void exportKdmToUmlTransformation(IPath pathParameter) {
        final InputStream transfoFileStream = this.getClass().getResourceAsStream(String.valueOf("resources/transformations") + "/KDMtoUML.atl");
        IPath path = pathParameter;
        if (path.getFileExtension() == null || !path.getFileExtension().equals("atl")) {
            path = path.addFileExtension("atl");
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        final IProject destinationProject = file.getProject();
        Job job = new Job(Messages.KDMtoUML2Converter_27){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (file.exists()) {
                        file.setContents(transfoFileStream, 1, monitor);
                    } else {
                        file.create(transfoFileStream, 1, monitor);
                    }
                }
                catch (CoreException coreException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            destinationProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        job.schedule();
    }

    public IFile instrumentAtlTranformationWithTraceability(InputStream sourceTransformation, URI atlFileUri) throws ATLCoreException {
        IModel targetModel;
        URI sourceModelUri = atlFileUri.trimFileExtension().appendFragment("-ATL_source").appendFileExtension("ecore");
        URI targetModelUri = atlFileUri.trimFileExtension().appendFragment("-ATL_target").appendFileExtension("ecore");
        IModel sourceModel = AtlParser.getDefault().parseToModel(sourceTransformation);
        if (sourceModel instanceof EMFModel) {
            EMFModel ecoreSourceModel = (EMFModel)sourceModel;
            Tools.saveModel((Resource)ecoreSourceModel.getResource(), (URI)sourceModelUri);
        }
        if ((targetModel = this.addTraceability(sourceModel, sourceModelUri, targetModelUri)) instanceof EMFModel) {
            EMFModel ecoreTargetModel = (EMFModel)targetModel;
            Tools.saveModel((Resource)ecoreTargetModel.getResource(), (URI)targetModelUri);
        }
        IFile result = null;
        try {
            result = this.parseFromModel(targetModel, atlFileUri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private final IModel addTraceability(IModel sourceModel, URI sourceModelUri, URI targetModelUri) throws ATLCoreException {
        final URL transformation = this.getClass().getResource(String.valueOf("resources/transformations") + "/ATL2WTracer.asm");
        HashMap<String, String> modelHandlers = new HashMap<String, String>();
        String atlMetaModelName = "ATL";
        modelHandlers.put(atlMetaModelName, "EMF");
        final HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("modelHandlers", modelHandlers);
        options.put("IS_REFINING", true);
        String launcherName = "EMF-specific VM";
        final ILauncher launcher = CoreService.getLauncher((String)launcherName);
        launcher.initialize(options);
        ModelFactory factory = CoreService.createModelFactory((String)launcher.getDefaultModelFactoryName());
        IInjector injector = CoreService.getInjector((String)factory.getDefaultInjectorName());
        IExtractor extractor = CoreService.getExtractor((String)factory.getDefaultExtractorName());
        IReferenceModel atlMM = factory.getBuiltInResource("ATL.ecore");
        HashMap<String, Object> modelOptions = new HashMap<String, Object>();
        String inModelName = "IN";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", sourceModelUri.toString());
        modelOptions.put("newModel", false);
        IModel input = factory.newModel(atlMM, modelOptions);
        injector.inject(input, sourceModelUri.toString());
        launcher.addInModel(input, inModelName, atlMetaModelName);
        modelOptions = new HashMap();
        inModelName = "OUT";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", targetModelUri.toString());
        modelOptions.put("newModel", true);
        IModel outputInstance = factory.newModel(atlMM, modelOptions);
        launcher.addOutModel(outputInstance, inModelName, atlMetaModelName);
        options.put("continueAfterError", "true");
        options.put("printExecutionTime", "true");
        Job transformationThread = new Job(Messages.KDMtoUML2Converter_42){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    launcher.launch("run", monitor, options, new Object[]{transformation.openStream()});
                }
                catch (IOException e) {
                    result = Status.CANCEL_STATUS;
                    e.printStackTrace();
                }
                return result;
            }
        };
        transformationThread.schedule();
        try {
            transformationThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        extractor.extract(outputInstance, targetModelUri.toString());
        return outputInstance;
    }

    public final IFile parseFromModel(IModel transformationModel, URI atlFileUri) throws IOException {
        IFile file;
        block27: {
            file = null;
            OutputStream out = null;
            Path atlFilePath = null;
            if (atlFileUri.isPlatformResource()) {
                PipedInputStream in;
                block26: {
                    atlFilePath = new Path(atlFileUri.toPlatformString(false));
                    file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)atlFilePath);
                    in = new PipedInputStream();
                    out = new PipedOutputStream(in);
                    try {
                        try {
                            AtlParser.getDefault().extract(transformationModel, out, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    if (file.exists()) {
                        file.setContents((InputStream)in, 1, null);
                        break block27;
                    }
                    file.create((InputStream)in, 1, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            } else {
                atlFilePath = new Path(atlFileUri.toFileString());
                out = new FileOutputStream(atlFilePath.toFile());
                try {
                    try {
                        AtlParser.getDefault().extract(transformationModel, out, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }
}

