/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.kdm.uml2converter.actions;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.kdm.uml2converter.KdmToUml2Activator;
import org.eclipse.gmt.modisco.kdm.uml2converter.actions.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverUmlModelFromKdmModel
extends AbstractDiscovererImpl
implements Discoverer {
    private final String sourceExtension = "kdm";
    private final String targetExtension = "uml";
    private final DiscoveryParameter customTransformationParameter = new DiscoveryParameterImpl("CustomTransformation", DiscoveryParameterDirectionKind.in, IFile.class, false);

    public final DiscoveryParameter getCustomTransformationParameter() {
        return this.customTransformationParameter;
    }

    public boolean isApplicableTo(Object source) {
        IFile iFile;
        String extension;
        boolean result = false;
        if (source instanceof IFile && (extension = (iFile = (IFile)source).getFileExtension()) != null && extension.equals("kdm")) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return Messages.DiscoverUmlModelFromKdmModel_4;
    }

    public DiscoverUmlModelFromKdmModel() {
        this.getBasicDiscovererParameters().add(this.customTransformationParameter);
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        IPath path;
        Resource result;
        block15: {
            Object value;
            result = null;
            URI target = null;
            if (parameters.containsKey(this.getTargetUriParameter()) && (value = parameters.get(this.getTargetUriParameter())) instanceof URI) {
                target = (URI)value;
            }
            IFile iFile = (IFile)source;
            String sourcePath = iFile.getLocation().toString();
            Object tempPath = iFile.getLocation().removeFileExtension().addFileExtension("uml");
            if (target != null) {
                tempPath = target.isRelative() ? ResourcesPlugin.getWorkspace().getRoot().getFullPath().append(target.path()) : new Path(target.toFileString());
            }
            path = tempPath;
            try {
                try {
                    KDMtoUML2Converter transfo = new KDMtoUML2Converter();
                    XMIResourceImpl kdmModel = new XMIResourceImpl();
                    kdmModel.setURI(URI.createFileURI((String)sourcePath));
                    URI outputURI = URI.createFileURI((String)path.toString());
                    Resource[] resources = null;
                    if (parameters.containsKey(this.getCustomTransformationParameter())) {
                        Object object = parameters.get(this.getCustomTransformationParameter());
                        System.out.println(object);
                        System.out.println(object.getClass());
                    } else {
                        resources = transfo.getUML2ModelFromKDMModel((Resource)kdmModel, false, outputURI);
                    }
                    result = resources[0];
                }
                catch (Exception e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
                    try {
                        iFile.getParent().refreshLocal(1, null);
                    }
                    catch (Exception e1) {
                        MoDiscoLogger.logWarning((Throwable)e1, (Plugin)KdmToUml2Activator.getDefault());
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    iFile.getParent().refreshLocal(1, null);
                }
                catch (Exception e1) {
                    MoDiscoLogger.logWarning((Throwable)e1, (Plugin)KdmToUml2Activator.getDefault());
                }
                throw throwable;
            }
            try {
                iFile.getParent().refreshLocal(1, null);
            }
            catch (Exception e1) {
                MoDiscoLogger.logWarning((Throwable)e1, (Plugin)KdmToUml2Activator.getDefault());
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IFile ifile = root.getFileForLocation(path);
                    if (ifile != null && ifile.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                    }
                }
                catch (PartInitException e) {
                    MoDiscoLogger.logWarning((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
                }
            }
        });
        parameters.put(this.getTargetModelParameter(), result);
    }
}

