/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.core.internal.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.query.JavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.internal.Activator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;

public class ImplementationClassName
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        JavaModelQuery modelQuery = (JavaModelQuery)ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL) {
            if (modelQuery.getImplementationClassName() == null) {
                return ctx.createFailureStatus(new Object[]{modelQuery.getImplementationClassName()});
            }
            URI uri = modelQuery.eResource().getURI();
            String containerName = uri.segment(1);
            if (uri.segment(0).equals("plugin")) {
                Bundle bundle = Platform.getBundle((String)containerName);
                try {
                    bundle.loadClass(modelQuery.getImplementationClassName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return ctx.createFailureStatus(new Object[]{modelQuery.getImplementationClassName()});
                }
            }
            if (uri.segment(0).equals("resource")) {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot wsr = ws.getRoot();
                IProject iproject = wsr.getProject(containerName);
                IJavaProject javaProject = JavaCore.create((IProject)iproject);
                try {
                    IType type = javaProject.findType(modelQuery.getImplementationClassName());
                    if (type == null) {
                        return ctx.createFailureStatus(new Object[]{modelQuery.getImplementationClassName()});
                    }
                }
                catch (JavaModelException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            } else {
                Exception e = new Exception("Unexpected query model location:" + uri.toString());
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return ctx.createSuccessStatus();
    }
}

