/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.core.java.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.infra.common.core.internal.builder.EcoreCatalog;
import org.eclipse.gmt.modisco.infra.common.core.internal.resource.MoDiscoResourceSet;
import org.eclipse.gmt.modisco.infra.query.JavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.QueryPackage;
import org.eclipse.gmt.modisco.infra.query.core.AbstractModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.IModelQueryFactory;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.core.exception.ExecutionEnvironmentException;
import org.eclipse.gmt.modisco.infra.query.core.exception.MissingBundleException;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.internal.Activator;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.java.internal.JavaModelQueryAdapter;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaModelQueryFactory
implements IModelQueryFactory {
    private static IResourceChangeListener changeListner;
    private static HashMap<IProject, Bundle> bundleMap;
    private static boolean loadExternalDtdFeatureAvailable;

    static {
        bundleMap = new HashMap();
        loadExternalDtdFeatureAvailable = true;
    }

    public JavaModelQueryFactory() {
        if (changeListner == null) {
            changeListner = JavaModelQueryFactory.initChangeListener();
        }
    }

    @Override
    public AbstractModelQuery create(ModelQuery modelQuery, Bundle bundle) throws ModelQueryException {
        if (!(modelQuery instanceof JavaModelQuery)) {
            ModelQueryException e = new ModelQueryException("Wrong kind of modelQuery: " + modelQuery.getClass().getSimpleName() + "found, " + JavaModelQuery.class.getSimpleName() + " expected.");
            throw e;
        }
        AbstractModelQuery javaModelQueryInst = null;
        try {
            Bundle localBundle;
            JavaModelQuery javaModelQuery = (JavaModelQuery)modelQuery;
            if (bundle == null) {
                ManifestElement[] manifestElements;
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                URI uri = ModelQuerySetCatalog.getSingleton().getURI(modelQuery.getModelQuerySet().getName());
                String fileString = uri.toPlatformString(true);
                IResource file = ws.getRoot().findMember((IPath)new Path(fileString));
                IProject project = file.getProject();
                localBundle = bundleMap.get(project);
                if (localBundle == null) {
                    localBundle = Activator.getDefault().installBundle(project);
                    this.searchPluginXml(project, localBundle);
                    bundleMap.put(project, localBundle);
                    javaModelQuery = (JavaModelQuery)ModelQuerySetCatalog.getSingleton().getModelQuerySet(javaModelQuery.getModelQuerySet().getName()).getQuery(javaModelQuery.getName());
                }
                String requiredExecEnv = (String)localBundle.getHeaders().get("Bundle-RequiredExecutionEnvironment");
                Properties p = System.getProperties();
                String availableExecEnv = (String)p.get("org.osgi.framework.executionenvironment");
                if (!availableExecEnv.contains(requiredExecEnv)) {
                    throw new ExecutionEnvironmentException(requiredExecEnv, availableExecEnv);
                }
                String dependencies = (String)localBundle.getHeaders().get("Require-Bundle");
                ManifestElement[] manifestElementArray = manifestElements = ManifestElement.parseHeader((String)"Require-Bundle", (String)dependencies);
                int n = manifestElements.length;
                int n2 = 0;
                while (n2 < n) {
                    ManifestElement manifestElement = manifestElementArray[n2];
                    String bundleName = manifestElement.getValue();
                    if (Platform.getBundle((String)bundleName) == null) {
                        throw new MissingBundleException(bundleName);
                    }
                    ++n2;
                }
            } else {
                localBundle = bundle;
            }
            String className = javaModelQuery.getImplementationClassName();
            if (className == null || className.length() == 0) {
                throw new ModelQueryExecutionException("implementationClassName is empty");
            }
            Class javaModelQueryClass = localBundle.loadClass(className);
            if (!IJavaModelQuery.class.isAssignableFrom(javaModelQueryClass)) {
                Exception e = new Exception(String.valueOf(className) + " does not implement " + IJavaModelQuery.class.getSimpleName() + ".");
                throw e;
            }
            javaModelQueryInst = this.createJavaModelQueryImpl(javaModelQuery, javaModelQueryClass);
            javaModelQueryInst.setCheckResult(bundle != null);
        }
        catch (ExecutionEnvironmentException e) {
            throw e;
        }
        catch (MissingBundleException e) {
            throw e;
        }
        catch (Exception e) {
            ModelQueryException mqe = new ModelQueryException("Failed to load the model query: " + modelQuery.getModelQuerySet().getName() + "::" + modelQuery.getName(), e);
            Status status = new Status(4, "org.eclipse.gmt.modisco.infra.query.core", mqe.getMessage(), (Throwable)mqe);
            Activator.getDefault().getLog().log((IStatus)status);
            throw mqe;
        }
        return javaModelQueryInst;
    }

    private AbstractModelQuery createJavaModelQueryImpl(JavaModelQuery javaModelQuery, Class<?> javaModelQueryClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        IJavaModelQuery javaModelQueryInst = (IJavaModelQuery)javaModelQueryClass.newInstance();
        JavaModelQueryAdapter adapter = new JavaModelQueryAdapter((ModelQuery)javaModelQuery, javaModelQueryInst);
        return adapter;
    }

    @Override
    public EClass getManagedModelQueryType() {
        return QueryPackage.eINSTANCE.getJavaModelQuery();
    }

    static HashMap<IProject, Bundle> getBundleMap() {
        return bundleMap;
    }

    private static IResourceChangeListener initChangeListener() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event != null) {
                    this.chekDelta(event.getDelta());
                }
            }

            private void chekDelta(IResourceDelta delta) {
                if (delta != null) {
                    IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                    int n = iResourceDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResourceDelta subdelta = iResourceDeltaArray[n2];
                        this.chekDelta(subdelta);
                        ++n2;
                    }
                    IResource resource = delta.getResource();
                    if (resource != null) {
                        IProject project = resource.getProject();
                        Set<IProject> listened = JavaModelQueryFactory.getBundleMap().keySet();
                        if (listened.contains(project) && "class".equals(resource.getFileExtension()) && project.getLocation() != null) {
                            JavaModelQueryFactory.getBundleMap().remove(project);
                        }
                    }
                }
            }
        };
        workspace.addResourceChangeListener(listener);
        return listener;
    }

    @Deprecated
    EPackage searchPluginXml(String uri, IFile declarationFile) throws IOException, ParserConfigurationException, SAXException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        IFile pluginFile = declarationFile.getProject().getFile("plugin.xml");
        EPackage result = null;
        if (pluginFile.exists()) {
            Handler2 handler = new Handler2(declarationFile, uri);
            this.parse(new FileInputStream(pluginFile.getLocation().toFile()), handler);
            result = handler.getEPackage();
        }
        return result;
    }

    void searchPluginXml(IProject project, Bundle bundle) throws IOException, ParserConfigurationException, SAXException {
        IFile pluginFile = project.getFile("plugin.xml");
        if (pluginFile.exists()) {
            Handler handler = new Handler();
            this.parse(new FileInputStream(pluginFile.getLocation().toFile()), handler);
            handler.getEPackages(bundle);
        }
    }

    private final void parse(FileInputStream fileInputStream, DefaultHandler handler) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setValidating(false);
        SAXParser p = f.newSAXParser();
        XMLReader reader = p.getXMLReader();
        if (loadExternalDtdFeatureAvailable) {
            try {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                loadExternalDtdFeatureAvailable = false;
            }
        }
        p.parse((InputStream)fileInputStream, handler);
    }

    public class Handler
    extends DefaultHandler {
        private boolean isInGPExtension = false;
        private final List<EPackageDescription> ePackageDescriptions = new ArrayList<EPackageDescription>();

        public void getEPackages(Bundle bundle) {
            if (this.ePackageDescriptions.size() > 0) {
                for (EPackageDescription epackDescription : this.ePackageDescriptions) {
                    EPackage ePackage = epackDescription.getEPackage(bundle);
                    MoDiscoResourceSet.getResourceSetSingleton().aResourceHasBeenLoaded(ePackage.eResource());
                }
            }
        }

        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            if (qname.equals("extension")) {
                int i = 0;
                while (i < attributes.getLength()) {
                    if (attributes.getLocalName(i).equals("point") && attributes.getValue(i).equals("org.eclipse.emf.ecore.generated_package")) {
                        this.isInGPExtension = true;
                        break;
                    }
                    ++i;
                }
            } else if (this.isInGPExtension && qname.equals("package")) {
                String nsUri = null;
                String classString = null;
                int i = 0;
                while (i < attributes.getLength()) {
                    if (attributes.getLocalName(i).equals("uri")) {
                        nsUri = attributes.getValue(i);
                    } else if (attributes.getLocalName(i).equals("class")) {
                        classString = attributes.getValue(i);
                    }
                    ++i;
                }
                this.ePackageDescriptions.add(new EPackageDescription(nsUri, classString));
            }
        }

        public void endElement(String uri, String localname, String qName) throws SAXException {
            if (localname.equals("extension")) {
                this.isInGPExtension = false;
            }
        }

        private class EPackageDescription {
            private final String className;
            private final String nsUri;

            public EPackageDescription(String nsUri, String classString) {
                this.className = classString;
                this.nsUri = nsUri;
            }

            public EPackage getEPackage(Bundle bundle) {
                EPackage ePackage = null;
                try {
                    if (this.className != null && this.nsUri != null) {
                        Class ePackageClass = bundle.loadClass(this.className);
                        Field instanceField = ePackageClass.getField("eINSTANCE");
                        ePackage = (EPackage)instanceField.get(null);
                        EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
                    }
                }
                catch (Exception exception) {
                    Status status2 = new Status(4, "org.eclipse.gmt.modisco.infra.common.core", "Failed to load an ePackage: " + this.nsUri);
                    Activator.getDefault().getLog().log((IStatus)status2);
                }
                return ePackage;
            }
        }
    }

    @Deprecated
    private class Handler2
    extends DefaultHandler
    implements BundleListener {
        private String className = null;
        private EPackage ePackage = null;
        private boolean isInGPExtension = false;
        private final IProject project;
        private final String nsUriToFound;
        private final IFile declarationFile;
        private String bundleName;

        public Handler2(IFile declarationFile, String nsURI) {
            this.declarationFile = declarationFile;
            this.project = declarationFile.getProject();
            this.nsUriToFound = nsURI;
        }

        public EPackage getEPackage() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
            if (this.className != null) {
                EPackage.Registry.INSTANCE.remove((Object)this.nsUriToFound);
                Bundle bundle = Activator.getDefault().installBundle(this.project);
                try {
                    this.ePackage = EPackage.Registry.INSTANCE.getEPackage(this.nsUriToFound);
                }
                catch (Exception exception) {
                    Status status2 = new Status(2, "org.eclipse.gmt.modisco.infra.common.core", "Failed to get the ePackage: " + this.nsUriToFound);
                    Activator.getDefault().getLog().log((IStatus)status2);
                }
                if (this.ePackage == null) {
                    Class ePackageClass = bundle.loadClass(this.className);
                    Field instanceField = ePackageClass.getField("eINSTANCE");
                    this.ePackage = (EPackage)instanceField.get(null);
                    EPackage.Registry.INSTANCE.put((Object)this.ePackage.getNsURI(), (Object)this.ePackage);
                }
                this.bundleName = bundle.getSymbolicName();
                bundle.getBundleContext().addBundleListener((BundleListener)this);
            }
            return this.ePackage;
        }

        public void bundleChanged(BundleEvent event) {
            try {
                if (event.getBundle().getSymbolicName().equals(this.bundleName)) {
                    Status status = new Status(1, "org.eclipse.gmt.modisco.infra.query.core", "Bundle change detected: " + event.getBundle().getSymbolicName());
                    Activator.getDefault().getLog().log((IStatus)status);
                    EcoreCatalog.getSingleton().addWSFile(this.declarationFile);
                }
            }
            catch (Exception e) {
                Status status2 = new Status(4, "org.eclipse.gmt.modisco.infra.query.core", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status2);
            }
        }

        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            block9: {
                block10: {
                    if (!qname.equals("extension")) break block10;
                    int i = 0;
                    while (i < attributes.getLength()) {
                        if (attributes.getLocalName(i).equals("point") && attributes.getValue(i).equals("org.eclipse.emf.ecore.generated_package")) {
                            this.isInGPExtension = true;
                            break block9;
                        }
                        ++i;
                    }
                    break block9;
                }
                if (!this.isInGPExtension || !qname.equals("package")) break block9;
                String nsUri = null;
                String classString = null;
                int i = 0;
                while (i < attributes.getLength()) {
                    if (attributes.getLocalName(i).equals("uri")) {
                        nsUri = attributes.getValue(i);
                    } else if (attributes.getLocalName(i).equals("class")) {
                        classString = attributes.getValue(i);
                    }
                    ++i;
                }
                if (this.nsUriToFound.equals(nsUri)) {
                    try {
                        this.className = classString;
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.eclipse.gmt.modisco.infra.common.core", e.getMessage(), (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                }
            }
        }

        public void endElement(String uri, String localname, String qName) throws SAXException {
            if (localname.equals("extension")) {
                this.isInGPExtension = false;
            }
        }
    }
}

