/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.core;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.customization.CustomizationEngine;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.util.ColorProvider;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.StringUtils;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeItem
implements ITreeElement {
    private final EAttribute attribute;
    private final EObject parent;
    private final ITreeElement treeParent;
    private final BrowserConfiguration browserConfiguration;
    private int cachedCount = -1;

    public AttributeItem(EObject parent, ITreeElement treeParent, EAttribute attribute, BrowserConfiguration browserConfiguration) {
        this.parent = parent;
        this.attribute = attribute;
        this.treeParent = treeParent;
        this.browserConfiguration = browserConfiguration;
    }

    public EAttribute getAttribute() {
        return this.attribute;
    }

    public int getCount() {
        if (this.cachedCount == -1) {
            Object value = this.localGet();
            this.cachedCount = this.attribute.isMany() ? ((List)value).size() : (value != null ? 1 : 0);
        }
        return this.cachedCount;
    }

    private Object localGet() {
        Object value;
        if (this.attribute instanceof FacetAttribute) {
            try {
                value = this.browserConfiguration.getFacetContext().get(this.parent, (EStructuralFeature)this.attribute);
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
                value = null;
            }
        } else {
            value = this.parent.eGet((EStructuralFeature)this.attribute);
        }
        return value;
    }

    @Override
    public String getText() {
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        String customizedLabel = customizationEngine.getAttributeLabel(this.facetOrParentClass(), this.attribute.getName(), this.parent);
        String staticText = AttributeItem.getStaticText(this.attribute, this.browserConfiguration.isShowMultiplicity(), customizedLabel);
        String strCount = this.attribute.isMany() ? " (" + this.getCount() + ")" : "";
        String strValue = this.getValueText();
        strValue = StringUtils.truncateBeforeNewline((String)strValue);
        return String.valueOf(staticText) + strCount + strValue;
    }

    public String getValueText() {
        Object value;
        String strValue = !this.attribute.isMany() ? ((value = this.localGet()) != null ? " = " + value.toString() : "") : "";
        return strValue;
    }

    public static String getStaticText(EAttribute attribute, boolean showMultiplicity, String customizedName) {
        String multiplicity = "";
        if (showMultiplicity) {
            String multLow = attribute.isRequired() ? "1" : "0";
            String multHigh = attribute.isMany() ? "*" : "1";
            multiplicity = " [" + multLow + ".." + multHigh + "]";
        }
        String prefix = attribute.isDerived() ? "/" : "";
        String attributeName = customizedName != null ? customizedName : attribute.getName();
        return String.valueOf(prefix) + attributeName + multiplicity;
    }

    @Override
    public Image getImage() {
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        Image customizedIcon = customizationEngine.getAttributeIcon(this.facetOrParentClass(), this.attribute.getName(), this.parent);
        if (customizedIcon != null) {
            return customizedIcon;
        }
        if (this.attribute instanceof FacetAttribute) {
            return ImageProvider.getInstance().getFacetAttributeIcon();
        }
        return ImageProvider.getInstance().getAttributeIcon();
    }

    public EObject getParent() {
        return this.parent;
    }

    @Override
    public ITreeElement getTreeParent() {
        return this.treeParent;
    }

    @Override
    public boolean hasChildren() {
        return this.attribute.isMany() && this.getCount() > 0;
    }

    @Override
    public List<?> getChildren() {
        if (this.attribute.isMany()) {
            List children = (List)this.parent.eGet((EStructuralFeature)this.attribute);
            return Collections.unmodifiableList(children);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Color getForeground() {
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        Color color = customizationEngine.getAttributeColor(this.facetOrParentClass(), this.attribute.getName(), this.parent);
        if (color != null) {
            return color;
        }
        if (this.getCount() == 0) {
            return ColorProvider.getInstance().getGray();
        }
        return null;
    }

    @Override
    public Color getBackground() {
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        Color color = customizationEngine.getAttributeBackgroundColor(this.facetOrParentClass(), this.attribute.getName(), this.parent);
        return color;
    }

    @Override
    public Font getFont() {
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        Font customizedFont = customizationEngine.getCustomizedAttributeFont(this.facetOrParentClass(), this.attribute.getName(), this.browserConfiguration.getCustomFont(), this.parent);
        return customizedFont;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeItem) {
            AttributeItem other = (AttributeItem)obj;
            return this.attribute.equals(other.attribute) && this.parent.equals(other.parent);
        }
        return false;
    }

    public int hashCode() {
        return this.attribute.hashCode() * 47 + this.parent.hashCode() + 13;
    }

    public EClass facetOrParentClass() {
        if (this.attribute instanceof FacetAttribute) {
            Facet facet = (Facet)this.attribute.eContainer();
            return facet;
        }
        return this.parent.eClass();
    }
}

