/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.browser.core.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.queries.SelectedQuery;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.browser.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryItem
implements ITreeElement {
    private final EObject parent;
    private final ITreeElement treeParent;
    private final SelectedQuery query;
    private final BrowserConfiguration browserConfiguration;
    private List<?> cachedChildren = null;
    private int cachedChildrenModCount = -1;

    public QueryItem(EObject parent, ITreeElement treeParent, SelectedQuery query, BrowserConfiguration browserConfiguration) {
        this.parent = parent;
        this.treeParent = treeParent;
        this.query = query;
        this.browserConfiguration = browserConfiguration;
    }

    @Override
    public String getText() {
        String text;
        if (!this.query.isExecuted()) {
            return String.valueOf(this.query.getModelQuery().getName()) + " (?)";
        }
        Object queryResult = this.query.getResult();
        if (queryResult instanceof Collection) {
            Collection elements = (Collection)queryResult;
            return String.valueOf(this.query.getModelQuery().getName()) + " (" + elements.size() + ")";
        }
        if (queryResult instanceof EObject) {
            EObject eObject = (EObject)queryResult;
            text = ModelElementItem.getDisplayName(eObject, this.browserConfiguration);
        } else {
            text = queryResult == null ? "null" : queryResult.toString();
        }
        return String.valueOf(this.query.getModelQuery().getName()) + " = " + text;
    }

    @Override
    public Image getImage() {
        return ImageProvider.getInstance().getQueryIcon();
    }

    public Object getParent() {
        return this.parent;
    }

    @Override
    public ITreeElement getTreeParent() {
        return this.treeParent;
    }

    @Override
    public List<?> getChildren() {
        if (this.cachedChildrenModCount != this.browserConfiguration.getModCount()) {
            Object queryResult = this.query.getResult();
            if (queryResult == null) {
                this.cachedChildren = Collections.emptyList();
            } else if (queryResult instanceof EObject) {
                EObject element = (EObject)queryResult;
                this.cachedChildren = Collections.singletonList(new ModelElementItem(element, this, this.browserConfiguration));
            } else if (queryResult instanceof Collection) {
                Collection elements = (Collection)queryResult;
                ArrayList<ModelElementItem> children = new ArrayList<ModelElementItem>();
                for (Object element : elements) {
                    if (element instanceof EObject) {
                        EObject eObject = (EObject)element;
                        children.add(new ModelElementItem(eObject, this, this.browserConfiguration));
                        continue;
                    }
                    children.add((ModelElementItem)element);
                }
                this.cachedChildren = Collections.unmodifiableList(children);
            } else {
                this.cachedChildren = Collections.singletonList(queryResult);
            }
            this.cachedChildrenModCount = this.browserConfiguration.getModCount();
        }
        return this.cachedChildren;
    }

    @Override
    public boolean hasChildren() {
        if (!this.query.isExecuted()) {
            return true;
        }
        return this.getChildren().size() > 0;
    }

    @Override
    public Font getFont() {
        return null;
    }

    @Override
    public Color getForeground() {
        return null;
    }

    @Override
    public Color getBackground() {
        return null;
    }

    public SelectedQuery getQuery() {
        return this.query;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryItem) {
            QueryItem other = (QueryItem)obj;
            return Util.safeEquals(this.query, other.query) && this.parent.equals(other.parent);
        }
        return false;
    }

    public int hashCode() {
        int parentHashCode = this.parent.hashCode() + 13;
        if (this.query != null) {
            return this.query.hashCode() * 47 + parentHashCode;
        }
        return parentHashCode;
    }
}

