/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.InstancesForMetaclasses;
import org.eclipse.gmt.modisco.infra.browser.customization.CustomizationEngine;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.queries.SelectedQueriesManager;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.core.FacetContext;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserConfiguration {
    public static final String FONT_SIZE_DELTA_PROP = "fontSizeDelta";
    public static final int NOT_YET_ASKED = -2;
    private static final String SHOW_EMPTY_LINKS_SETTING = "showEmptyLinks";
    private static final String SHOW_DERIVED_LINKS_SETTING = "showDerivedLinks";
    private static final String SORT_INSTANCES_SETTING = "showInstances";
    private static final String SORT_LINKS_SETTING = "sortLinks";
    private static final String SORT_LINKS_BY_TYPE_SETTING = "sortLinksByType";
    private static final String SHOW_FULL_QUALIFIED_NAMES_SETTING = "showFullQualifiedNames";
    private static final String SHOW_MULTIPLICITY_SETTING = "showMultiplicity";
    private static final String SHOW_OPPOSITE_LINKS_SETTING = "showOppositeLinks";
    private static final String SHOW_CONTAINER_SETTING = "showContainer";
    private static final String METACLASSES_SORT_MODE = "metaclassesSortMode";
    private static final String SHOW_METACLASSES_FULL_QUALIFIED_NAMES_SETTING = "showMetaclassesFullQualifiedNames";
    private static final String SHOW_EMPTY_METACLASSES = "showEmptyMetaclasses";
    private static final String GROUP_BY_PACKAGE = "groupByPackage";
    private static final String DISPLAY_INSTANCES_OF_SUBCLASSES = "displayInstancesOfSubclasses";
    private static final String SHOW_DERIVATION_TREE = "showDerivationTree";
    private static final String SHOW_ATTRIBUTES = "showAttributes";
    private static final String SHOW_EMPTY_ATTRIBUTES = "showEmptyAttributes";
    private static final String SHOW_ORDERING = "showOrdering";
    private static final String FONT_SIZE_DELTA = "fontSizeDelta";
    private static final String SHOW_TYPE_OF_LINKS = "showTypeOfLinks";
    private static final String SHOW_ELEMENT_IDS = "showElementIDs";
    private static final String SHOW_URI = "showURI";
    private boolean showTypeOfLinks = false;
    private boolean showEmptyLinks = false;
    private boolean sortInstances = false;
    private boolean sortLinks = false;
    private boolean sortLinksByType = false;
    private boolean showDerivedLinks = false;
    private boolean showFullQualifiedNames = false;
    private boolean showMetaclassesFullQualifiedNames = false;
    private boolean showMultiplicity = false;
    private boolean showOppositeLinks = false;
    private boolean showContainer = false;
    private boolean showEmptyMetaclasses = false;
    private boolean groupByPackage = false;
    private boolean displayInstancesOfSubclasses;
    private boolean showDerivationTree;
    private MetaclassesSortMode fMetaclassesSortMode = MetaclassesSortMode.ByName;
    private boolean showAttributes;
    private boolean showEmptyAttributes;
    private boolean showOrdering;
    private boolean showElementIDs;
    private boolean showURI;
    private int fontSizeDelta = 0;
    private Font customFont = null;
    private Font customItalicFont = null;
    private ResourceSet resourceSet;
    private InstancesForMetaclasses instancesForMetaclasses;
    private ComposedAdapterFactory adapterFactoryWithRegistry;
    private EcoreBrowser editor;
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private CustomizationEngine customizationEngine;
    private SelectedQueriesManager selectedQueriesManager;
    private int modificationCount = 0;
    private int referencedResourcesLoadingDepth = -2;
    private final FacetContext facetContext = new FacetContext();
    private Set<Resource> browsedResources;

    public BrowserConfiguration(EcoreBrowser editor) {
        this();
        this.editor = editor;
    }

    public BrowserConfiguration() {
        this.createCustomizationEngine();
        this.adapterFactoryWithRegistry = new ComposedAdapterFactory();
    }

    public EcoreBrowser getEditor() {
        return this.editor;
    }

    public boolean isShowEmptyLinks() {
        return this.showEmptyLinks;
    }

    public void setShowEmptyLinks(boolean showEmptyLinks) {
        this.showEmptyLinks = showEmptyLinks;
        ++this.modificationCount;
    }

    public boolean isSortInstances() {
        return this.sortInstances;
    }

    public void setSortInstances(boolean sortInstances) {
        this.sortInstances = sortInstances;
        ++this.modificationCount;
    }

    public boolean isShowDerivedLinks() {
        return this.showDerivedLinks;
    }

    public void setShowDerivedLinks(boolean showDerivedLinks) {
        this.showDerivedLinks = showDerivedLinks;
        ++this.modificationCount;
    }

    public boolean isShowFullQualifiedNames() {
        return this.showFullQualifiedNames;
    }

    public void setShowFullQualifiedNames(boolean showFullQualifiedNames) {
        this.showFullQualifiedNames = showFullQualifiedNames;
        ++this.modificationCount;
    }

    public boolean isShowMultiplicity() {
        return this.showMultiplicity;
    }

    public void setShowMultiplicity(boolean showMultiplicity) {
        this.showMultiplicity = showMultiplicity;
        ++this.modificationCount;
    }

    public boolean isShowOppositeLinks() {
        return this.showOppositeLinks;
    }

    public void setShowOppositeLinks(boolean showOppositeLinks) {
        this.showOppositeLinks = showOppositeLinks;
        ++this.modificationCount;
    }

    public boolean isShowContainer() {
        return this.showContainer;
    }

    public void setShowContainer(boolean showContainer) {
        this.showContainer = showContainer;
        ++this.modificationCount;
    }

    public MetaclassesSortMode getMetaclassesSortMode() {
        return this.fMetaclassesSortMode;
    }

    public void setMetaclassesSortMode(MetaclassesSortMode mode) {
        this.fMetaclassesSortMode = mode;
        ++this.modificationCount;
    }

    public boolean isShowMetaclassesFullQualifiedNames() {
        return this.showMetaclassesFullQualifiedNames;
    }

    public void setShowMetaclassesFullQualifiedNames(boolean value) {
        this.showMetaclassesFullQualifiedNames = value;
        ++this.modificationCount;
    }

    public void setSortLinks(boolean value) {
        this.sortLinks = value;
        ++this.modificationCount;
    }

    public boolean isSortLinks() {
        return this.sortLinks;
    }

    public void setSortLinksByType(boolean value) {
        this.sortLinksByType = value;
        ++this.modificationCount;
    }

    public boolean isSortLinksByType() {
        return this.sortLinksByType;
    }

    public void setShowEmptyMetaclasses(boolean value) {
        this.showEmptyMetaclasses = value;
        ++this.modificationCount;
    }

    public boolean isShowEmptyMetaclasses() {
        return this.showEmptyMetaclasses;
    }

    public void setGroupByPackage(boolean value) {
        this.groupByPackage = value;
        ++this.modificationCount;
    }

    public boolean isGroupByPackage() {
        return this.groupByPackage;
    }

    public void setDisplayInstancesOfSubclasses(boolean value) {
        this.displayInstancesOfSubclasses = value;
        ++this.modificationCount;
    }

    public boolean isDisplayInstancesOfSubclasses() {
        return this.displayInstancesOfSubclasses;
    }

    public void setShowDerivationTree(boolean value) {
        this.showDerivationTree = value;
        ++this.modificationCount;
    }

    public boolean isShowDerivationTree() {
        return this.showDerivationTree;
    }

    public void setShowAttributes(boolean value) {
        this.showAttributes = value;
        ++this.modificationCount;
    }

    public boolean isShowAttributes() {
        return this.showAttributes;
    }

    public void setShowEmptyAttributes(boolean value) {
        this.showEmptyAttributes = value;
        ++this.modificationCount;
    }

    public boolean isShowEmptyAttributes() {
        return this.showEmptyAttributes;
    }

    public void setShowOrdering(boolean value) {
        this.showOrdering = value;
        ++this.modificationCount;
    }

    public boolean isShowOrdering() {
        return this.showOrdering;
    }

    public void setShowTypeOfLinks(boolean value) {
        this.showTypeOfLinks = value;
        ++this.modificationCount;
    }

    public boolean isShowTypeOfLinks() {
        return this.showTypeOfLinks;
    }

    public void setShowElementIDs(boolean showElementIDs) {
        this.showElementIDs = showElementIDs;
        ++this.modificationCount;
    }

    public boolean isShowElementIDs() {
        return this.showElementIDs;
    }

    public void setShowURI(boolean showURI) {
        this.showURI = showURI;
        ++this.modificationCount;
    }

    public boolean isShowURI() {
        return this.showURI;
    }

    public void setFontSizeDelta(int value) {
        this.firePropertyChanged("fontSizeDelta", this.fontSizeDelta, value);
        this.fontSizeDelta = value;
        ++this.modificationCount;
    }

    public int getFontSizeDelta() {
        return this.fontSizeDelta;
    }

    public void setCustomFont(Font customFont) {
        if (this.customFont != null && this.customFont != JFaceResources.getDialogFont() && this.customFont != customFont) {
            this.customFont.dispose();
        }
        this.customFont = customFont;
        ++this.modificationCount;
    }

    public Font getCustomFont() {
        return this.customFont;
    }

    public void setCustomItalicFont(Font customItalicFont) {
        if (this.customItalicFont != null && this.customItalicFont != JFaceResources.getDialogFont() && this.customItalicFont != customItalicFont) {
            this.customItalicFont.dispose();
        }
        this.customItalicFont = customItalicFont;
        ++this.modificationCount;
    }

    public Font getCustomItalicFont() {
        return this.customItalicFont;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setInstancesForMetaclasses(InstancesForMetaclasses instancesForMetaclasses) {
        this.instancesForMetaclasses = instancesForMetaclasses;
    }

    public InstancesForMetaclasses getInstancesForMetaclasses() {
        return this.instancesForMetaclasses;
    }

    public void setAdapterFactoryWithRegistry(ComposedAdapterFactory adapterFactoryWithRegistry) {
        this.adapterFactoryWithRegistry = adapterFactoryWithRegistry;
        ++this.modificationCount;
    }

    public ComposedAdapterFactory getAdapterFactoryWithRegistry() {
        return this.adapterFactoryWithRegistry;
    }

    public void createCustomizationEngine() {
        this.customizationEngine = new CustomizationEngine();
        ++this.modificationCount;
        this.customizationEngine.addChangeListener(new ChangeListener(){

            public void changed() {
                BrowserConfiguration browserConfiguration = BrowserConfiguration.this;
                browserConfiguration.modificationCount = browserConfiguration.modificationCount + 1;
            }
        });
    }

    public CustomizationEngine getCustomizationEngine() {
        return this.customizationEngine;
    }

    public void load() {
        IDialogSettings dialogSettings = MoDiscoBrowserPlugin.getPlugin().getDialogSettings();
        this.showEmptyLinks = this.getPreference(SHOW_EMPTY_LINKS_SETTING, true, dialogSettings);
        this.showDerivedLinks = this.getPreference(SHOW_DERIVED_LINKS_SETTING, true, dialogSettings);
        this.sortInstances = this.getPreference(SORT_INSTANCES_SETTING, false, dialogSettings);
        this.sortLinks = this.getPreference(SORT_LINKS_SETTING, false, dialogSettings);
        this.sortLinksByType = this.getPreference(SORT_LINKS_BY_TYPE_SETTING, false, dialogSettings);
        this.showFullQualifiedNames = this.getPreference(SHOW_FULL_QUALIFIED_NAMES_SETTING, false, dialogSettings);
        this.showMultiplicity = this.getPreference(SHOW_MULTIPLICITY_SETTING, false, dialogSettings);
        this.showOppositeLinks = this.getPreference(SHOW_OPPOSITE_LINKS_SETTING, false, dialogSettings);
        this.showContainer = this.getPreference(SHOW_CONTAINER_SETTING, true, dialogSettings);
        this.showMetaclassesFullQualifiedNames = this.getPreference(SHOW_METACLASSES_FULL_QUALIFIED_NAMES_SETTING, false, dialogSettings);
        this.showEmptyMetaclasses = this.getPreference(SHOW_EMPTY_METACLASSES, false, dialogSettings);
        this.groupByPackage = this.getPreference(GROUP_BY_PACKAGE, false, dialogSettings);
        this.displayInstancesOfSubclasses = this.getPreference(DISPLAY_INSTANCES_OF_SUBCLASSES, false, dialogSettings);
        this.showDerivationTree = this.getPreference(SHOW_DERIVATION_TREE, false, dialogSettings);
        this.showAttributes = this.getPreference(SHOW_ATTRIBUTES, true, dialogSettings);
        this.showEmptyAttributes = this.getPreference(SHOW_EMPTY_ATTRIBUTES, true, dialogSettings);
        this.showOrdering = this.getPreference(SHOW_ORDERING, false, dialogSettings);
        this.fontSizeDelta = this.getPreference("fontSizeDelta", 0, dialogSettings);
        this.showTypeOfLinks = this.getPreference(SHOW_TYPE_OF_LINKS, false, dialogSettings);
        this.showElementIDs = this.getPreference(SHOW_ELEMENT_IDS, false, dialogSettings);
        this.showURI = this.getPreference(SHOW_URI, false, dialogSettings);
        String metaclassesSortMode = dialogSettings.get(METACLASSES_SORT_MODE);
        if (metaclassesSortMode != null) {
            this.fMetaclassesSortMode = MetaclassesSortMode.valueOf(metaclassesSortMode);
        }
        ++this.modificationCount;
    }

    private boolean getPreference(String settingKey, boolean defaultValue, IDialogSettings dialogSettings) {
        String value = dialogSettings.get(settingKey);
        if (value == null) {
            return defaultValue;
        }
        Boolean b = new Boolean(false);
        b.booleanValue();
        return Boolean.valueOf(value);
    }

    private int getPreference(String settingKey, int defaultValue, IDialogSettings dialogSettings) {
        String value = dialogSettings.get(settingKey);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public void save() {
        IDialogSettings dialogSettings = MoDiscoBrowserPlugin.getPlugin().getDialogSettings();
        dialogSettings.put(SHOW_EMPTY_LINKS_SETTING, this.showEmptyLinks);
        dialogSettings.put(SHOW_DERIVED_LINKS_SETTING, this.showDerivedLinks);
        dialogSettings.put(SORT_INSTANCES_SETTING, this.sortInstances);
        dialogSettings.put(SORT_LINKS_SETTING, this.sortLinks);
        dialogSettings.put(SORT_LINKS_BY_TYPE_SETTING, this.sortLinksByType);
        dialogSettings.put(SHOW_FULL_QUALIFIED_NAMES_SETTING, this.showFullQualifiedNames);
        dialogSettings.put(SHOW_MULTIPLICITY_SETTING, this.showMultiplicity);
        dialogSettings.put(SHOW_OPPOSITE_LINKS_SETTING, this.showOppositeLinks);
        dialogSettings.put(SHOW_CONTAINER_SETTING, this.showContainer);
        dialogSettings.put(METACLASSES_SORT_MODE, this.fMetaclassesSortMode.name());
        dialogSettings.put(SHOW_METACLASSES_FULL_QUALIFIED_NAMES_SETTING, this.showMetaclassesFullQualifiedNames);
        dialogSettings.put(SHOW_EMPTY_METACLASSES, this.showEmptyMetaclasses);
        dialogSettings.put(GROUP_BY_PACKAGE, this.groupByPackage);
        dialogSettings.put(DISPLAY_INSTANCES_OF_SUBCLASSES, this.displayInstancesOfSubclasses);
        dialogSettings.put(SHOW_DERIVATION_TREE, this.showDerivationTree);
        dialogSettings.put(SHOW_ATTRIBUTES, this.showAttributes);
        dialogSettings.put(SHOW_EMPTY_ATTRIBUTES, this.showEmptyAttributes);
        dialogSettings.put(SHOW_ORDERING, this.showOrdering);
        dialogSettings.put("fontSizeDelta", this.fontSizeDelta);
        dialogSettings.put(SHOW_TYPE_OF_LINKS, this.showTypeOfLinks);
        dialogSettings.put(SHOW_ELEMENT_IDS, this.showElementIDs);
        dialogSettings.put(SHOW_URI, this.showURI);
    }

    public void dispose() {
        this.editor = null;
    }

    public String getMetamodelName() {
        String[] parts;
        String nsURI = this.getMetamodelURI();
        if (nsURI != null && (parts = nsURI.split("/")).length > 0) {
            return parts[parts.length - 1];
        }
        return null;
    }

    public String getMetamodelURI() {
        EPackage ePackage;
        EObject firstElement;
        EClass eClass;
        Resource firstResource;
        EList contents;
        EList resources = this.resourceSet.getResources();
        if (resources.size() > 0 && (contents = (firstResource = (Resource)resources.get(0)).getContents()).size() > 0 && (eClass = (firstElement = (EObject)contents.get(0)).eClass()) != null && (ePackage = eClass.getEPackage()) != null) {
            return ePackage.getNsURI();
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChanged(String propertyName, int oldValue, int newValue) {
        for (PropertyChangeListener listener : this.listeners) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, new Integer(oldValue), new Integer(newValue));
            listener.propertyChange(event);
        }
    }

    public int getModCount() {
        return this.modificationCount;
    }

    public FacetContext getFacetContext() {
        return this.facetContext;
    }

    public void loadFacet(Facet facet) {
        try {
            this.facetContext.addFacet(facet);
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Error loading Facet", (Plugin)MoDiscoBrowserPlugin.getPlugin());
        }
        ++this.modificationCount;
    }

    public Set<Facet> getLoadedFacets() {
        return this.facetContext.getAppliedFacets();
    }

    public void clearFacets() {
        try {
            this.facetContext.clear();
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Error clearing Facets", (Plugin)MoDiscoBrowserPlugin.getPlugin());
        }
        ++this.modificationCount;
    }

    public void setSelectedQueriesManager(SelectedQueriesManager selectedQueriesManager) {
        this.selectedQueriesManager = selectedQueriesManager;
        ++this.modificationCount;
        this.selectedQueriesManager.addChangeListener(new ChangeListener(){

            public void changed() {
                BrowserConfiguration browserConfiguration = BrowserConfiguration.this;
                browserConfiguration.modificationCount = browserConfiguration.modificationCount + 1;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        BrowserConfiguration.this.editor.refreshDelayed(false);
                    }
                });
            }
        });
    }

    public SelectedQueriesManager getSelectedQueriesManager() {
        return this.selectedQueriesManager;
    }

    public void setBrowsedResources(Set<Resource> browsedResources) {
        this.browsedResources = browsedResources;
        ++this.modificationCount;
    }

    public Set<Resource> getBrowsedResources() {
        return Collections.unmodifiableSet(this.browsedResources);
    }

    public void setReferencedResourcesLoadingDepth(int referencedResourcesLoadingDepth) {
        this.referencedResourcesLoadingDepth = referencedResourcesLoadingDepth;
        ++this.modificationCount;
    }

    public int getReferencedResourcesLoadingDepth() {
        return this.referencedResourcesLoadingDepth;
    }

    public void touch() {
        ++this.modificationCount;
    }

    public static interface ChangeListener
    extends EventListener {
        public void changed();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetaclassesSortMode {
        ByName,
        ByCount;

    }
}

