/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.InstancesForMetaclass;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditorInput
implements IEditorInput {
    private final List<? extends Object> elements;
    private final List<EAttribute> attributes;
    private final List<EReference> references;
    private final BrowserConfiguration browserConfiguration;
    private final String description;
    private HashSet<EClass> metaclasses;
    private Map<Object, EObject> contextMap;

    public TableEditorInput(BrowserConfiguration browserConfiguration, List<? extends Object> elements, String description) {
        this.browserConfiguration = browserConfiguration;
        this.elements = elements;
        this.description = description;
        this.metaclasses = new HashSet();
        for (Object object : elements) {
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            this.metaclasses.add(eObject.eClass());
            try {
                List facets = this.browserConfiguration.getFacetContext().getFacets(eObject);
                this.metaclasses.addAll(facets);
            }
            catch (ModelQueryException e) {
                MoDiscoBrowserPlugin.logException(e);
            }
        }
        HashSet hashSet = new HashSet();
        for (EClass eClass : this.metaclasses) {
            hashSet.addAll(eClass.getEAllAttributes());
        }
        HashSet referenceSet = new HashSet();
        for (EClass eClass : this.metaclasses) {
            referenceSet.addAll(eClass.getEAllReferences());
        }
        this.attributes = new ArrayList<EAttribute>(hashSet);
        this.references = new ArrayList<EReference>(referenceSet);
    }

    public TableEditorInput(BrowserConfiguration browserConfiguration, List<? extends Object> elements, String description, Map<Object, EObject> contextMap) {
        this(browserConfiguration, elements, description);
        this.contextMap = contextMap;
    }

    public TableEditorInput(BrowserConfiguration browserConfiguration, EClass eClass, String description) {
        this.browserConfiguration = browserConfiguration;
        this.description = description;
        InstancesForMetaclass instances = this.browserConfiguration.getInstancesForMetaclasses().getInstancesForMetaclass(eClass);
        this.elements = new ArrayList<EObject>(instances.getElements());
        this.attributes = new ArrayList<EAttribute>((Collection<EAttribute>)eClass.getEAllAttributes());
        this.references = new ArrayList<EReference>((Collection<EReference>)eClass.getEAllReferences());
    }

    public List<? extends Object> getElements() {
        return this.elements;
    }

    public List<EAttribute> getAttributes() {
        return this.attributes;
    }

    public List<EReference> getReferences() {
        return this.references;
    }

    public String getDescription() {
        return this.description;
    }

    public BrowserConfiguration getBrowserConfiguration() {
        return this.browserConfiguration;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return Messages.TableEditorInput_editorName_TableViewer;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return Messages.TableEditorInput_tooltip_TableViewer;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public EClass[] getMetaclasses() {
        return this.metaclasses.toArray(new EClass[this.metaclasses.size()]);
    }

    public ElementsDescription getElementsDescription() {
        ElementsDescription elementsDescription = new ElementsDescription();
        for (Object object : this.elements) {
            if (object instanceof EObject) {
                elementsDescription.containsEObjects = true;
                continue;
            }
            elementsDescription.containsPrimitiveTypes = true;
        }
        return elementsDescription;
    }

    public Map<Object, EObject> getContextMap() {
        return this.contextMap;
    }

    public class ElementsDescription {
        private boolean containsEObjects;
        private boolean containsPrimitiveTypes;

        public boolean containsEObjects() {
            return this.containsEObjects;
        }

        public boolean containsPrimitiveTypes() {
            return this.containsPrimitiveTypes;
        }
    }
}

