/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors.table;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.editors.table.ColumnDescription;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.StringUtils;
import org.eclipse.gmt.modisco.infra.facet.FacetAttribute;
import org.eclipse.gmt.modisco.infra.facet.FacetReference;
import org.eclipse.gmt.modisco.infra.facet.core.FacetContext;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditorLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final BrowserConfiguration browserConfiguration;
    private final List<ColumnDescription> columns;
    private final Map<Object, EObject> contextMap;

    public TableEditorLabelProvider(List<ColumnDescription> columns, BrowserConfiguration browserConfiguration, Map<Object, EObject> contextMap) {
        this.columns = columns;
        this.browserConfiguration = browserConfiguration;
        this.contextMap = contextMap;
    }

    public String getTextFor(Object element) {
        if (element == null) {
            return "null";
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return new ModelElementItem(eObject, null, this.browserConfiguration).getText();
        }
        return element.toString();
    }

    public Image getImageFor(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return new ModelElementItem(eObject, null, this.browserConfiguration).getImage();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex >= this.columns.size()) return null;
        ColumnDescription columnDescription = this.columns.get(columnIndex);
        switch (columnDescription.getType()) {
            case DEFAULT_LABEL: {
                return this.getImageFor(element);
            }
            case REFERENCE: {
                Object refValue;
                EReference reference = columnDescription.getReference();
                EObject eObject = (EObject)element;
                if (reference instanceof FacetReference) {
                    try {
                        FacetContext facetContext = this.browserConfiguration.getFacetContext();
                        if (!facetContext.getReferences(eObject).contains((Object)reference)) return null;
                        refValue = facetContext.get(eObject, (EStructuralFeature)reference);
                    }
                    catch (Exception e) {
                        MoDiscoBrowserPlugin.logException(e);
                        return null;
                    }
                } else {
                    if (!eObject.eClass().getEAllReferences().contains((Object)reference)) {
                        return null;
                    }
                    refValue = eObject.eGet((EStructuralFeature)reference);
                }
                if (reference.isMany()) {
                    EList list = (EList)refValue;
                    if (list.size() != 1) return null;
                    return this.getImageFor(list.get(0));
                }
                if (refValue == null) return null;
                return this.getImageFor(refValue);
            }
            case ECONTAINER: {
                return this.getImageFor(((EObject)element).eContainer());
            }
            case CONTEXT: {
                return this.getContextColumnImage(element);
            }
            default: {
                return null;
            }
        }
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex >= this.columns.size()) {
            return Messages.TableEditorLabelProvider_indexOutOfBounds;
        }
        ColumnDescription columnDescription = this.columns.get(columnIndex);
        switch (columnDescription.getType()) {
            case DEFAULT_LABEL: {
                return this.getTextFor(element);
            }
            case METACLASS_NAME: {
                return this.getMetaclassColumnText(element);
            }
            case CONTEXT: {
                return this.getContextColumnText(element);
            }
            case ATTRIBUTE: {
                return this.getAttributeColumnText(element, columnDescription);
            }
            case REFERENCE: {
                return this.getReferenceColumnText(element, columnDescription);
            }
            case ECONTAINER: {
                return this.getTextFor(((EObject)element).eContainer());
            }
        }
        return Messages.TableEditorLabelProvider_unexpectedColumnType;
    }

    private String getMetaclassColumnText(Object element) {
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            EClass eClass = eObject.eClass();
            if (eClass == null) {
                return Messages.TableEditorLabelProvider_none;
            }
            return eClass.getName();
        }
        return element.getClass().getSimpleName();
    }

    private String getContextColumnText(Object element) {
        if (this.contextMap != null) {
            EObject eObject = this.contextMap.get(element);
            return this.getTextFor(eObject);
        }
        return Messages.TableEditorLabelProvider_nullContext;
    }

    private Image getContextColumnImage(Object element) {
        if (this.contextMap != null) {
            EObject eObject = this.contextMap.get(element);
            return this.getImageFor(eObject);
        }
        return null;
    }

    private String getAttributeColumnText(Object element, ColumnDescription columnDescription) {
        Object attrValue;
        EObject eObject = (EObject)element;
        EAttribute attribute = columnDescription.getAttribute();
        if (attribute instanceof FacetAttribute) {
            try {
                FacetContext facetContext = this.browserConfiguration.getFacetContext();
                if (!facetContext.getAttributes(eObject).contains((Object)attribute)) {
                    return Messages.TableEditorLabelProvider_NA;
                }
                attrValue = facetContext.get(eObject, (EStructuralFeature)attribute);
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
                return Messages.TableEditorLabelProvider_error;
            }
        } else {
            if (!eObject.eClass().getEAllAttributes().contains((Object)attribute)) {
                return Messages.TableEditorLabelProvider_NA;
            }
            attrValue = eObject.eGet((EStructuralFeature)attribute);
        }
        if (attrValue == null) {
            return "null";
        }
        return StringUtils.truncateBeforeNewline((String)attrValue.toString());
    }

    private String getReferenceColumnText(Object element, ColumnDescription columnDescription) {
        Object refValue;
        EObject eObject = (EObject)element;
        EReference reference = columnDescription.getReference();
        if (reference instanceof FacetReference) {
            try {
                FacetContext facetContext = this.browserConfiguration.getFacetContext();
                if (!facetContext.getReferences(eObject).contains((Object)reference)) {
                    return Messages.TableEditorLabelProvider_NA;
                }
                refValue = facetContext.get(eObject, (EStructuralFeature)reference);
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
                return Messages.TableEditorLabelProvider_error;
            }
        } else {
            if (!eObject.eClass().getEAllReferences().contains((Object)reference)) {
                return Messages.TableEditorLabelProvider_NA;
            }
            refValue = eObject.eGet((EStructuralFeature)reference);
        }
        if (refValue == null) {
            return "null";
        }
        if (reference.isMany()) {
            EList list = (EList)refValue;
            if (list.size() == 1) {
                return this.getTextFor(list.get(0));
            }
            return "(" + list.size() + ")";
        }
        return this.getTextFor(refValue);
    }
}

