/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;


/**
 * Allows to watch different driver errors message or message
 * @author Nicolas Payeau
 */
public class MoDiscoWorkLaunchConfigurationDialog extends LaunchConfigurationsDialog{

	private MoDiscoWorkLaunchConfigurationTabGroupViewer tabViewer;
	private DriverPage driverPage;
	
	public MoDiscoWorkLaunchConfigurationDialog(Shell shell,
			ILaunchGroup group, Composite rootContainer, DriverPage driverPage) {
		super(shell, (LaunchGroupExtension) group);
		this.tabViewer = new MoDiscoWorkLaunchConfigurationTabGroupViewer(rootContainer, this);
		this.driverPage = driverPage;
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationDialog#getActiveTab()
	 */
	@Override
	public ILaunchConfigurationTab getActiveTab() {
		return this.tabViewer.getActiveTab();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationDialog#getMode()
	 */
	@Override
	public String getMode() {
		return ILaunchManager.RUN_MODE;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationDialog#getTabs()
	 */
	@Override
	public ILaunchConfigurationTab[] getTabs() {
		return this.tabViewer.getTabs();//this.controllerDriverpage.getTabs();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationDialog#updateButtons()
	 */
	@Override
	public void updateButtons() {
		this.tabViewer.refresh();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchConfigurationDialog#updateMessage()
	 */
	@Override
	public void updateMessage() {
		this.driverPage.setErrorMessage(this.tabViewer.getErrorMesssage());
		this.driverPage.setMessage(this.tabViewer.getMessage());
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.operation.IRunnableContext#run(boolean, boolean, org.eclipse.jface.operation.IRunnableWithProgress)
	 */
	@Override
	public void run(boolean fork, boolean cancelable,
			IRunnableWithProgress runnable) throws InvocationTargetException,
			InterruptedException {
		if (this.driverPage.getShell() != null && this.driverPage.getShell().isVisible()) {
			try {
				ProgressMonitorDialog p = new ProgressMonitorDialog(PlatformUI
						.createDisplay().getActiveShell());
				p.run(true, true, runnable);
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		} else {
			PlatformUI.getWorkbench().getProgressService().run(fork,
					cancelable, runnable);
		}
	}

	public void setPageComplete(boolean complete){
		this.driverPage.setPageComplete(complete);
	}
	
	public MoDiscoWorkLaunchConfigurationTabGroupViewer getTabGroupViewer() {
		return this.tabViewer;
	}
}
