/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui.common;

import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/**
 * This class defines pop-up menu for MoDiscoWorkflowTab
 * @author Nicolas Payneau
 */
public class MoDiscoWorkflowPopPup {

	private Menu menuSelection;
	private Menu menuNoSelection;
	private AdditionalButtonsComposite buttonComposite;
	private boolean enableButton;
	
	public MoDiscoWorkflowPopPup(AdditionalButtonsComposite buttonComposite) {
		this.buttonComposite = buttonComposite;
	}
	
	
	/**
	 * Create a pop-up menu on item selected with right click
	 * @param shell Shell of selection
	 */
	public void createPopupMenuSelectionItem(Shell shell){
		if(this.menuSelection==null){
			this.menuSelection = new Menu (shell, SWT.POP_UP);
			MenuItem itemEdit = new MenuItem (this.menuSelection, SWT.PUSH);
			itemEdit.setText (Messages.MoDiscoWorkflowPopPup_0);
			itemEdit.setImage(Activator.getImageDescriptor(Constants.pathIconEdit).createImage());
			itemEdit.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					MoDiscoWorkflowPopPup.this.buttonComposite.editAdditionalMoDiscoWork();				
				}
			});
			MenuItem itemRemove = new MenuItem (this.menuSelection, SWT.PUSH);
			itemRemove.setText (Messages.MoDiscoWorkflowPopPup_1);
			itemRemove.setImage(Activator.getImageDescriptor(Constants.pathIconRemove).createImage());
			itemRemove.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					MoDiscoWorkflowPopPup.this.buttonComposite.removeAdditionalMoDiscoWork()	;		
				}
			});
			MenuItem itemUp = new MenuItem (this.menuSelection, SWT.PUSH);
			itemUp.setText (Messages.MoDiscoWorkflowPopPup_2);
			itemUp.setImage(Activator.getImageDescriptor(Constants.pathIconUp).createImage());
			itemUp.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					MoDiscoWorkflowPopPup.this.buttonComposite.upAdditionalMoDiscoWork();			
				}
			});
			MenuItem itemDown = new MenuItem (this.menuSelection, SWT.PUSH);
			itemDown.setText (Messages.MoDiscoWorkflowPopPup_3);
			itemDown.setImage(Activator.getImageDescriptor(Constants.pathIconDown).createImage());
			itemDown.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					MoDiscoWorkflowPopPup.this.buttonComposite.downAdditionalMoDiscoWork();				
				}
			});
			if(this.enableButton){
				itemEdit.setEnabled(true);
				itemRemove.setEnabled(true);
				itemUp.setEnabled(true);
				itemDown.setEnabled(true);
			}else{
				itemEdit.setEnabled(false);
				itemUp.setEnabled(false);
				itemDown.setEnabled(false);
			}
		}
	}
	
	/**
	 * Create a pop-up menu on right click on table selection (Not item selected)
	 * @param shell
	 */
	public void createPopupMenuNoSelectionItem(Shell shell){
		if(this.menuNoSelection==null){
			this.menuNoSelection = new Menu (shell, SWT.POP_UP);
			MenuItem itemNew = new MenuItem (this.menuNoSelection, SWT.PUSH);
			itemNew.setText (Messages.MoDiscoWorkflowPopPup_4);
			itemNew.setImage(Activator.getImageDescriptor(Constants.pathIconNew).createImage());
			itemNew.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					MoDiscoWorkflowPopPup.this.buttonComposite.newAdditionalMoDiscoWork();				
				}
			});
			MenuItem itemLoad = new MenuItem (this.menuNoSelection, SWT.PUSH);
			itemLoad.setText (Messages.MoDiscoWorkflowPopPup_5);
			itemLoad.setImage(Activator.getImageDescriptor(Constants.pathIconLoad).createImage());
			itemLoad.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					MoDiscoWorkflowPopPup.this.buttonComposite.loadAdditionalTransformation();				
				}
			});
			if(this.enableButton){
				itemNew.setEnabled(true);
				itemLoad.setEnabled(true);
			}else{
				itemNew.setEnabled(false);
				itemLoad.setEnabled(false);
			}
		}
	}
	
	/**
	 * Allows to manage the rights of button
	 * @param allRight True if user as all the rights otherwise false
	 */
	public void enabledButtonToManageMoDiscoWorkflow(boolean allRight) {
		this.enableButton = allRight;
	}
	
	//Getters
	public Menu getMenuSelection() {
		return this.menuSelection;
	}

	public Menu getMenuNoSelection() {
		return this.menuNoSelection;
	}	
}
