/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.discoverer.ui;


import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryManager;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.ui.launch.DiscovererLaunchConstants;
import org.eclipse.gmt.modisco.workflow.AbstractDriverCore;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.driver.discoverer.Activator;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Direction;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameterValue;

public class LaunchDriverModiscoDiscoverer extends AbstractDriverCore implements DriverInterface {
	
	public LaunchDriverModiscoDiscoverer() {
		
	}

	@Override
	public String getTypeLaunchConfig() {
		return "org.eclipse.gmt.modisco.infra.discoverymanager.launchConfigurationType"; //$NON-NLS-1$
	}

	@Override
	public List<WorkParameter> getParameters(final ILaunchConfiguration configuration) {
		List<WorkParameter> parameters = new ArrayList<WorkParameter>();
		try {			
			String kind = configuration.getAttribute(DiscovererLaunchConstants.discovererKind, ""); //$NON-NLS-1$
			Discoverer discoverer = DiscoveryManager.getDefault().getDiscoverer(kind);
			/*
			 * initialization of discoverer parameters
			 */
			for (DiscoveryParameter discoveryParameter : discoverer.getDiscovererParameters()) {
				//				Object value = ParameterUtils.getInstance().deserializeParameterValue(parameter,
				//						configuration);
				try {			
					WorkParameter workParameter = this.createOneWorkParameter(discoveryParameter.getName(), Direction.get(discoveryParameter.getParameterDirectionKind().name()), discoveryParameter.getDescription(), discoveryParameter.isRequired(), discoveryParameter.getType());
					workParameter.setValue(this.deserializeParameterValue(configuration, discoveryParameter));
					parameters.add(workParameter);
				} catch (CoreException e) {
					MoDiscoLogger.logError(e, Messages.LaunchDriverModiscoDiscoverer_parameterBrokenValue, Activator.getDefault());
				}
			}
		} catch (CoreException e) {
			MoDiscoLogger.logError(e, Messages.LaunchDriverModiscoDiscoverer_kindOfDiscoverer, Activator.getDefault());
		}
		return parameters;
	}
	
	@SuppressWarnings("unchecked")
	private final WorkParameterValue deserializeParameterValue(final ILaunchConfiguration configuration, final DiscoveryParameter parameter) throws CoreException {
		WorkParameterValue result = null;
		Class<?> type = parameter.getType();
		// different options are available to retrieve the value
		if (type.equals(String.class)) {
			String value = configuration.getAttribute(parameter.getName(), ""); //$NON-NLS-1$
			result = this.createStringValue(value);
		} else if ((type.equals(Integer.TYPE)) || (type.equals(Integer.class))) {
			int value = configuration.getAttribute(parameter.getName(), 0);
			result = this.createIntegerValue(value); // autoboxing: int -> Integer
		} else if ((type.equals(Boolean.TYPE)) || (type.equals(Boolean.class))) {
			boolean value = configuration.getAttribute(parameter.getName(), false);
			result = this.createBooleanValue(value); // autoboxing: boolean -> Boolean
		} else if (List.class.isAssignableFrom(type)) {
			List<String> value = configuration.getAttribute(parameter.getName(), Collections
					.emptyList());
			result = this.createStringListValue(value);
		} else if (Set.class.isAssignableFrom(type)) {
			List<String> list = configuration.getAttribute(parameter.getName(), Collections
					.emptyList());
			result = this.createStringListValue(list);
		} else if (Map.class.isAssignableFrom(type)) {
			Map<String, String> value = configuration.getAttribute(parameter.getName(), Collections
					.emptyMap());
			result = this.createMapValue(value);
		} else {
			// TODO Object not managed, we have to retrieve a
			// ParameterFactory from an extension point
			result = this.createStringValue(""); //$NON-NLS-1$
		}
		return result;
	}
}
