/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.jet.ui;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.workflow.AbstractDriverCore;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.driver.jet.Constant;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Direction;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.jet.transform.JETLaunchConstants;

public class LaunchDriverJET extends AbstractDriverCore implements DriverInterface {

	public String getTypeLaunchConfig() {
		return Constant.typeLaunchConfiguration;
	}

	public List<WorkParameter> getParameters(ILaunchConfiguration configuration) {
		List<WorkParameter> parameters = new ArrayList<WorkParameter>();
		try {
			WorkParameter param = createOneWorkParameter(JETLaunchConstants.ID,Direction.IN,Messages.LaunchDriverJET_0,true,String.class);
			param.setValue(createStringValue(configuration.getAttribute(JETLaunchConstants.ID,(String)null)));
			parameters.add(param);
			
			WorkParameter param2 = createOneWorkParameter(JETLaunchConstants.LOG_FILTER_LEVEL,Direction.IN,Messages.LaunchDriverJET_1,false,Integer.class);
			param2.setValue(createIntegerValue(configuration.getAttribute(JETLaunchConstants.LOG_FILTER_LEVEL,0)));
			parameters.add(param2);

			WorkParameter param3 = createOneWorkParameter(JETLaunchConstants.SOURCE,Direction.IN,Messages.LaunchDriverJET_2,true,String.class);
			param3.setValue(createStringValue(configuration.getAttribute(JETLaunchConstants.SOURCE,(String)null)));
			parameters.add(param3);
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return parameters;
	}
}
