/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.common.core.internal.builder;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.resource.MoDiscoResourceSet;

/**
 * @author Grgoire Dup
 */
public class EcoreCatalog extends AbstractMoDiscoCatalog {

	private static EcoreCatalog singleton;
	private static Map<EPackage, IFile> ePackageToFileMap = new HashMap<EPackage, IFile>();

	public static EcoreCatalog getSingleton() {
		if (EcoreCatalog.singleton == null) {
			EcoreCatalog.singleton = new EcoreCatalog();
		}
		return EcoreCatalog.singleton;
	}

	protected EcoreCatalog() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getMoDiscoSubProtocol() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getRegistryExtensionPoint() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Class<?> getRootClass() {
		return EPackage.class;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getRootObjectName(final EObject rootObject) {
		return ((EPackage) rootObject).getName();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getRootObjectNsUri(final EObject rootObject) {
		return ((EPackage) rootObject).getNsURI();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected EObject openResource(final URI uri, final IResource file) {
		EPackage ePackage = (EPackage) super.openResource(uri, file);
		try {
			if (ePackage != null) {
				// EPackage generatedEPackage = null;
				// try {
				// generatedEPackage = searchPluginXml(ePackage.getNsURI(),
				// (IFile) file);
				// } catch (Exception e) {
				// IStatus status = new Status(IStatus.ERROR,
				// CommonModiscoActivator.PLUGIN_ID, e.getMessage(), e);
				// CommonModiscoActivator.getDefault().getLog().log(status);
				// }
				// if (generatedEPackage != null) {
				// ePackage = generatedEPackage;
				// } else {
				EcoreCatalog.ePackageToFileMap.put(ePackage, (IFile) file);
				URI mmUri = URI.createURI(getRootObjectNsUri(ePackage));
				Resource mmResource = null;
				try {
					ResourceSet rs = MoDiscoResourceSet.getResourceSetSingleton();
					mmResource = rs.getResource(mmUri, false);
				} catch (Exception e) {
					IStatus status = new Status(IStatus.WARNING, CommonModiscoActivator.PLUGIN_ID,
							e.getMessage(), e);
					CommonModiscoActivator.getDefault().getLog().log(status);
				}
				if (mmResource == null) {
					ResourceSet rs = MoDiscoResourceSet.getResourceSetSingleton();
					mmResource = rs.createResource(mmUri);
				}
				mmResource.getContents().clear();
				mmResource.getContents().add(ePackage);
				EPackage.Registry.INSTANCE.put(getRootObjectNsUri(ePackage), ePackage);
			}

			// }
			return ePackage;
		} catch (Exception e) {
			throw new RuntimeException("Failed to load: " //$NON-NLS-1$
					+ getRootObjectNsUri(ePackage), e);
		}
	}

	/**
	 * This method returns the original location of an EPackage
	 */
	public String getOriginalLocation(final EPackage ePackage) {
		IFile file = EcoreCatalog.ePackageToFileMap.get(ePackage);
		if (file == null) {
			return ""; //$NON-NLS-1$
		}
		return file.getLocation().toString();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Plugin getActivator() {
		return CommonModiscoActivator.getDefault();
	}

}
