/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.common.core.internal.resource;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;

/**
 * @author Grgoire Dup
 */
public class MoDiscoResourceListenerGroup {

	private final Map<IMoDiscoResourceListener, URI> listeners = new HashMap<IMoDiscoResourceListener, URI>();
	private final URI watchedResourceUri;

	public MoDiscoResourceListenerGroup(final URI watchedResourceUri) {
		this.watchedResourceUri = watchedResourceUri;
		if (MoDiscoResourceSet.DEBUG) {
			IStatus status = new Status(IStatus.INFO, CommonModiscoActivator.PLUGIN_ID, "[" //$NON-NLS-1$
					+ this.getClass().getSimpleName()
					+ "." + this.getClass().getSimpleName() + "()] " //$NON-NLS-1$ //$NON-NLS-2$
					+ this.watchedResourceUri);

			CommonModiscoActivator.getDefault().getLog().log(status);
		}
	}

	public void notifyChange() {
		if (MoDiscoResourceSet.DEBUG) {
			IStatus status = new Status(IStatus.INFO, CommonModiscoActivator.PLUGIN_ID, "[" //$NON-NLS-1$
					+ this.getClass().getSimpleName()
					+ ".notifyChange()] " + this.watchedResourceUri //$NON-NLS-1$
					+ " nbListeners=" + this.listeners.size()); //$NON-NLS-1$
			CommonModiscoActivator.getDefault().getLog().log(status);
		}
		for (IMoDiscoResourceListener listener : this.listeners.keySet()) {
			try {
				listener.aListenedResourceHasChanged(this.watchedResourceUri, this.listeners
						.get(listener));
			} catch (Exception e) {
				MoDiscoLogger.logError(e, "An exception happened while notifying change of: " //$NON-NLS-1$
						+ this.watchedResourceUri + " to: " + listener, CommonModiscoActivator //$NON-NLS-1$
						.getDefault());
			}
		}
	}

	public void addListener(final IMoDiscoResourceListener listener, final URI resourceUri) {
		this.listeners.put(listener, resourceUri);
	}

}
