/*******************************************************************************
 * Copyright (c) 2008, 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.common.core.internal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Bundle;

public final class FileUtils {

	private FileUtils() {
		// Nothing
	}

	/** Reads a file and returns its contents as a String */
	public static String getContents(final File file) throws java.io.IOException {
		final int bufferSize = 1024;
		StringBuilder contents = new StringBuilder(bufferSize);
		BufferedReader reader = new BufferedReader(new FileReader(file));
		char[] buffer = new char[bufferSize];
		int read = 0;
		while ((read = reader.read(buffer)) != -1) {
			contents.append(buffer, 0, read);
		}
		reader.close();
		return contents.toString();
	}

	public static void copyFileFromBundle(final String sourcePath, final IProject project,
			final String destinationPath, final Bundle bundleContainingResources)
			throws IOException, CoreException {
		InputStream source;
		try {
			URL url = bundleContainingResources.getResource(sourcePath);
			source = url.openStream();
		} catch (NullPointerException e) {
			URL url = bundleContainingResources.getEntry(sourcePath);
			try {
				source = url.openStream();
			} catch (NullPointerException e2) {
				throw new IOException(sourcePath + " not found."); //$NON-NLS-1$
			}
		}
		IFile javaFile = project.getFile(destinationPath);
		if (javaFile.exists()) {
			javaFile.delete(true, new NullProgressMonitor());
		}
		if (!javaFile.getParent().exists()) {
			FolderUtils.createFolder((IFolder) javaFile.getParent());
		}
		javaFile.create(source, true, new NullProgressMonitor());
	}

	public static void checkEMFResource(final URI uri, final int nbRoot) throws Exception {
		ResourceSet resourceSet = new ResourceSetImpl();
		Resource resource = resourceSet.getResource(uri, true);
		resource.load(Collections.EMPTY_MAP);
		EcoreUtil.resolveAll(resource);
		if (!(nbRoot == resource.getContents().size())) {
			throw new Exception("Wrong number of root element: " + nbRoot + " expected, " //$NON-NLS-1$ //$NON-NLS-2$
					+ resource.getContents().size() + " found."); //$NON-NLS-1$
		}
		if (!(resource.getErrors().size() == 0)) {
			throw new Exception("The resource contains errors."); //$NON-NLS-1$
		}
	}

}
