/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.text.queries;

import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.java.ParameterValueList;
import org.eclipse.gmt.modisco.java.AbstractMethodInvocation;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;

public class GetAbstractMethodInvocationText implements
		IJavaModelQuery<AbstractMethodInvocation, String> {

	public String evaluate(final AbstractMethodInvocation context,
			final ParameterValueList parameterValues)
			throws ModelQueryExecutionException {
		String abstractMethodInvocationText = ""; //$NON-NLS-1$
		if (context != null) {
			if (context.getMethod() != null) {
				if (context.getMethod().getName() != null) {

					abstractMethodInvocationText += context.getMethod()
							.getName();

					if (context.getMethod().getParameters() != null) {
						abstractMethodInvocationText += "("; //$NON-NLS-1$
						for (SingleVariableDeclaration test : context
								.getMethod().getParameters()) {
							abstractMethodInvocationText += test.getType()
									.getType().getName()
									+ " " + test.getName() + ", "; //$NON-NLS-1$ //$NON-NLS-2$
						}
						if (context.getMethod().getParameters().size() > 0) {
							abstractMethodInvocationText = abstractMethodInvocationText
									.substring(0, abstractMethodInvocationText
											.length() - 2);
						}
						abstractMethodInvocationText += ")"; //$NON-NLS-1$
					}
				}
			}
		}
		return abstractMethodInvocationText;
	}
}
