/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.text.queries;

import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.java.ParameterValueList;
import org.eclipse.gmt.modisco.java.ConstructorDeclaration;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;

public class GetConstructorDeclarationText implements
		IJavaModelQuery<ConstructorDeclaration, String> {

	public String evaluate(final ConstructorDeclaration context,
			final ParameterValueList parameterValues)
			throws ModelQueryExecutionException {
		if (context != null) {
			String constructorDeclarationTexte = "" + context.getName(); //$NON-NLS-1$
			if (context.getParameters() != null
					&& !context.getName().equalsIgnoreCase("")) { //$NON-NLS-1$
				constructorDeclarationTexte += "("; //$NON-NLS-1$
				for (SingleVariableDeclaration test : context
						.getParameters()) {
					constructorDeclarationTexte += test.getType().getType()
							.getName()
							+ " " + test.getName() + ", "; //$NON-NLS-1$ //$NON-NLS-2$
				}
				if (context.getParameters().size() > 0) {
					constructorDeclarationTexte = constructorDeclarationTexte
							.substring(0,
									constructorDeclarationTexte.length() - 2);
				}
				constructorDeclarationTexte += ")"; //$NON-NLS-1$
			}
			return constructorDeclarationTexte;
		}
		return ""; //$NON-NLS-1$
	}
}
