/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.text.queries;

import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.java.ParameterValueList;
import org.eclipse.gmt.modisco.java.FieldDeclaration;

public class GetFieldDeclarationText implements
		IJavaModelQuery<FieldDeclaration, String> {

	public String evaluate(final FieldDeclaration context,
			final ParameterValueList parameterValues)
			throws ModelQueryExecutionException {
		String fieldDeclarationTexte = ""; //$NON-NLS-1$
		if (context.getModifier() != null) {
			fieldDeclarationTexte += context.getModifier()
					.getVisibility().getName()
					+ " "; //$NON-NLS-1$
		}
		if (context.getType() != null) {
			if (context.getType().getType() != null) {
				if (context.getType().getType().getName() != null) {
					fieldDeclarationTexte += context.getType()
							.getType().getName()
							+ " "; //$NON-NLS-1$
				}
			}
		}
		if (context.getName() != null) {
			fieldDeclarationTexte += context.getName();
		} else {
			fieldDeclarationTexte += context.getFragments().get(0)
					.getName();
		}
		return fieldDeclarationTexte;
	}

}
