/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.text.queries;

import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.java.ParameterValueList;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;

public class GetMethodDeclarationText implements
		IJavaModelQuery<MethodDeclaration, String> {

	public String evaluate(final MethodDeclaration context,
			final ParameterValueList parameterValues)
			throws ModelQueryExecutionException {
		String completeMethodName = ""; //$NON-NLS-1$
		if (context.getModifier() != null) {
			if (!context.getModifier().getVisibility().getName()
					.equalsIgnoreCase("none")) { //$NON-NLS-1$
				completeMethodName += context.getModifier()
						.getVisibility().getName();
			}
		}
		if (context.getName() != null) {
			completeMethodName += " " + context.getName(); //$NON-NLS-1$
		}
		if (context.getParameters() != null) {
			completeMethodName += "("; //$NON-NLS-1$
			for (SingleVariableDeclaration test : context
					.getParameters()) {
				completeMethodName += test.getType().getType().getName()
						+ " " + test.getName() + ", "; //$NON-NLS-1$ //$NON-NLS-2$
			}
			if (context.getParameters().size() > 0) {
				completeMethodName = completeMethodName.substring(0,
						completeMethodName.length() - 2);
			}
			completeMethodName += ")"; //$NON-NLS-1$
		}
		return completeMethodName;
	}

}
