/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.text.queries;

import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.java.ParameterValueList;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractVariablesContainer;
import org.eclipse.gmt.modisco.java.Annotation;
import org.eclipse.gmt.modisco.java.Type;

public class GetTypeRef implements IJavaModelQuery<ASTNode, Type> {

	public Type evaluate(final ASTNode context,
			final ParameterValueList parameterValues)
			throws ModelQueryExecutionException {
		Type result = null;
		if (context instanceof AbstractVariablesContainer) {
			AbstractVariablesContainer contextCasted = (AbstractVariablesContainer) context;
			if (contextCasted.getType() != null) {
				result = contextCasted.getType().getType();
			}
		} else if (context instanceof Annotation) {
			Annotation contextCasted = (Annotation) context;
			if (contextCasted.getType() != null) {
				result = contextCasted.getType().getType();
			}
		} else {
			throw new ModelQueryExecutionException(
					"Unexpected context type: " //$NON-NLS-1$
							+ context.getClass().getSimpleName()
							+ " expected: AbstractVariablesContainer or Annotation in " + this.getClass().getSimpleName()); //$NON-NLS-1$
		}
		return result;
	}

}
