/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.query.ui.actions;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.gmt.modisco.infra.query.ui.wizards.CreateQueryWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IActionDelegate;

public class CreateQueryAction implements IActionDelegate {

	private ISelection fSelection;

	public CreateQueryAction() {
		// nothing
	}

	public void run(final IAction action) {
		if (this.fSelection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) this.fSelection;
			Object selected = structuredSelection.getFirstElement();
			ModelQuerySet modelQuerySet = null;
			EClass eClass = null;
			if (selected instanceof ModelQuerySet) {
				modelQuerySet = (ModelQuerySet) selected;
			} else if (selected instanceof EClass) {
				eClass = (EClass) selected;
			} else if (selected instanceof EObject) {
				EObject eObject = (EObject) selected;
				eClass = eObject.eClass();
			}

			CreateQueryWizard createQueryWizard = new CreateQueryWizard(modelQuerySet, eClass);
			WizardDialog wizardDialog = new WizardDialog(null, createQueryWizard);
			wizardDialog.open();
		}
	}

	public void selectionChanged(final IAction action, final ISelection selection) {
		this.fSelection = selection;
	}

}
