package org.eclipse.gmt.modisco.infra.query.ui.extensions;

import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.jface.wizard.IWizardPage;

public interface IQueryAttributesWizardPage extends IWizardPage {

	/**
	 * Initialize the wizard page
	 * 
	 * @param modelQuerySet
	 *            an existing query set, in which the query will be added
	 * @param modelQuery
	 *            the query that will be added to the query set when the wizard
	 *            finishes
	 */
	void init(ModelQuerySet modelQuerySet, ModelQuery modelQuery);

	/**
	 * Called when the wizard is finished to apply the attributes defined in the
	 * wizard page to the model query.
	 * 
	 * @param modelQuery
	 *            the query to which to apply the wizard page's attributes
	 */
	void apply(ModelQuery modelQuery);
}
