/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.query.ui.filters;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.ui.IActionFilter;

/** A filter for queries which are in the workspace */
public class WorkspaceQueryFilter implements IActionFilter {

	public static final String WORKSPACE_QUERY = "isWorkspaceQuery"; //$NON-NLS-1$

	public boolean testAttribute(final Object target, final String name, final String value) {
		if (WorkspaceQueryFilter.WORKSPACE_QUERY.equals(name)) {
			if (target instanceof ModelQuery) {
				ModelQuery modelQuery = (ModelQuery) target;
				Resource resource = modelQuery.eResource();
				URI uri = resource.getURI();
				return Boolean.toString(uri.isPlatformResource()).equalsIgnoreCase(value);
			}
		}
		return false;
	}

}
