/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.driver.modiscoworkflow.Activator;

public class ParseLaunchConfigurationFile {

	private BufferedReader bufferFile;
	private String idWorkflow;
	private List<String> listMinimalist;
	private List<String> listSerialize;
	private int modiscoWorkNumber = 0;
	private String resourcePath;

	public ParseLaunchConfigurationFile(File file) {
		InputStream ips;
		try {
			ips = new FileInputStream(file);
			InputStreamReader ipsr = new InputStreamReader(ips);
			this.bufferFile = new BufferedReader(ipsr);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		this.listMinimalist = new ArrayList<String>();
		this.listSerialize = new ArrayList<String>();
		parse();
	}

	private void parse() {
		try {
			String line = this.bufferFile.readLine();
			while (line != null) {
				keyOfLine(line);
				line = this.bufferFile.readLine();
			}
		} catch (FileNotFoundException e) {
			MoDiscoLogger.logWarning(e, Activator.getDefault());
		} catch (IOException e) {
			MoDiscoLogger.logWarning(e, Activator.getDefault());
		}
	}

	private void parseResourcePath(String line) {
		for (String s : line.split("value=\"")) { //$NON-NLS-1$
			if (s.indexOf("\"/>") != -1) { //$NON-NLS-1$
				if (s.split("\"/>").length > 0) { //$NON-NLS-1$
					this.resourcePath = s.split("\"/>")[0]; //$NON-NLS-1$
				}
				break;
			}
		}
	}

	private void parseMoDiscoWorkNumber(String line) {
		for (String s : line.split("value=\"")) { //$NON-NLS-1$
			if (s.indexOf("\"/>") != -1) { //$NON-NLS-1$
				if (s.split("\"/>").length > 0) { //$NON-NLS-1$
					this.modiscoWorkNumber = Integer.valueOf(s.split("\"/>")[0]); //$NON-NLS-1$
				}
				break;
			}
		}
	}

	private void parseListSerialize(String line) {
		for (String s : line.split("value=\"")) { //$NON-NLS-1$
			if (s.indexOf("\"/>") != -1) { //$NON-NLS-1$
				if (s.split("\"/>").length > 0) { //$NON-NLS-1$
					this.listSerialize.add(s.split("\"/>")[0]); //$NON-NLS-1$
				}
				break;
			}
		}
	}

	private void parseListMinimalist(String line) {
		for (String s : line.split("value=\"")) { //$NON-NLS-1$
			if (s.indexOf("\"/>") != -1) { //$NON-NLS-1$
				if (s.split("\"/>").length > 0) { //$NON-NLS-1$
					this.listMinimalist.add(s.split("\"/>")[0]); //$NON-NLS-1$
				}
				break;
			}
		}
	}

	private void parseIdWorkflow(String line) {
		for (String s : line.split("value=\"")) { //$NON-NLS-1$
			if (s.indexOf("\"/>") != -1) { //$NON-NLS-1$
				if (s.split("\"/>").length > 0) { //$NON-NLS-1$
					this.idWorkflow = s.split("\"/>")[0]; //$NON-NLS-1$
				}
				break;
			}
		}
	}

	public void save(ILaunchConfigurationWorkingCopy copy) {
		copy.setAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, this.idWorkflow);
		if (this.idWorkflow.equals(MoDiscoWorkflowLaunchConstants.idMinimaliste) == true) {
			saveEngineMinimalist(copy);
		} else {
			saveEngineMWE(copy);
		}
	}

	private void saveEngineMWE(ILaunchConfigurationWorkingCopy copy) {
		copy.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListSerialize, this.listSerialize);
		copy.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoWorkNumber, this.modiscoWorkNumber);
		copy.setAttribute(MoDiscoWorkflowLaunchConstants.resourcePath, this.resourcePath);
	}

	private void saveEngineMinimalist(ILaunchConfigurationWorkingCopy copy) {
		copy
				.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist,
						this.listMinimalist);
	}

	private void keyOfLine(String line) {
		String key = null;
		String[] s = line.split("key=\""); //$NON-NLS-1$
		if (s[0] != line && s.length > 1) {
			if (s[1].split("\"").length > 0) { //$NON-NLS-1$
				key = s[1].split("\"")[0]; //$NON-NLS-1$
				if (key.equals(MoDiscoWorkflowLaunchConstants.idWorkflow) == true) {
					parseIdWorkflow(line);
				} else if (key.equals(MoDiscoWorkflowLaunchConstants.moDiscoWorkNumber) == true) {
					parseMoDiscoWorkNumber(line);
				} else if (key.equals(MoDiscoWorkflowLaunchConstants.resourcePath) == true) {
					parseResourcePath(line);
				} else if (key.equals(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist) == true) {
					try {
						String lineList = this.bufferFile.readLine();
						while ((lineList != null) && (!lineList.equals("</listAttribute>"))) { //$NON-NLS-1$
							parseListMinimalist(lineList);
							lineList = this.bufferFile.readLine();
						}
					} catch (IOException e) {
						MoDiscoLogger.logWarning(e, Activator.getDefault());
					}
				} else if (key.equals(MoDiscoWorkflowLaunchConstants.moDiscoListSerialize) == true) {
					try {
						String lineList = this.bufferFile.readLine();
						while ((lineList != null) && (!lineList.equals("</listAttribute>"))) { //$NON-NLS-1$
							parseListSerialize(lineList);
							lineList = this.bufferFile.readLine();
						}
					} catch (IOException e) {
						MoDiscoLogger.logWarning(e, Activator.getDefault());
					}
				}
			}
		}
	}
}
